/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.event;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.client.render.item.JarBlockItemRenderer;
import cy.jdkdigital.productivebees.common.entity.bee.ConfigurableBee;
import cy.jdkdigital.productivebees.common.entity.bee.solitary.BlueBandedBee;
import cy.jdkdigital.productivebees.common.recipe.BeeFishingRecipe;
import cy.jdkdigital.productivebees.handler.bee.IInhabitantStorage;
import cy.jdkdigital.productivebees.init.ModAdvancements;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModConfiguredFeatures;
import cy.jdkdigital.productivebees.init.ModEntities;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModProfessions;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.setup.BeeReloadListener;
import cy.jdkdigital.productivebees.util.BeeHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.SaplingGrowTreeEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="productivebees")
public class EventHandler {
    @SubscribeEvent
    public static void onBlockGrow(SaplingGrowTreeEvent event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            ConfiguredFeature chosenFeature = null;
            float r = serverLevel.m_213780_().m_188501_();
            boolean hasFlower = EventHandler.hasFlowers(event.getLevel(), event.getPos());
            Block grownBlock = serverLevel.m_8055_(event.getPos()).m_60734_();
            if (hasFlower && (double)r < (Double)ProductiveBeesConfig.WORLD_GEN.nestConfigs.get("oak_wood_nest").get() && grownBlock.equals(Blocks.f_50746_)) {
                chosenFeature = (ConfiguredFeature)ModConfiguredFeatures.OAK_SOLITARY_NEST.get();
            } else if (hasFlower && (double)r < (Double)ProductiveBeesConfig.WORLD_GEN.nestConfigs.get("birch_wood_nest").get() && grownBlock.equals(Blocks.f_50748_)) {
                chosenFeature = (ConfiguredFeature)ModConfiguredFeatures.BIRCH_SOLITARY_NEST.get();
            } else if (hasFlower && (double)r < (Double)ProductiveBeesConfig.WORLD_GEN.nestConfigs.get("spruce_wood_nest").get() && grownBlock.equals(Blocks.f_50747_)) {
                chosenFeature = (ConfiguredFeature)ModConfiguredFeatures.SPRUCE_SOLITARY_NEST.get();
            } else if (hasFlower && (double)r < (Double)ProductiveBeesConfig.WORLD_GEN.nestConfigs.get("acacia_wood_nest").get() && grownBlock.equals(Blocks.f_50750_)) {
                chosenFeature = (ConfiguredFeature)ModConfiguredFeatures.ACACIA_SOLITARY_NEST.get();
            } else if (hasFlower && (double)r < (Double)ProductiveBeesConfig.WORLD_GEN.nestConfigs.get("dark_oak_wood_nest").get() && grownBlock.equals(Blocks.f_50751_)) {
                chosenFeature = (ConfiguredFeature)ModConfiguredFeatures.DARK_OAK_SOLITARY_NEST.get();
            } else if (hasFlower && (double)r < (Double)ProductiveBeesConfig.WORLD_GEN.nestConfigs.get("jungle_wood_nest").get() && grownBlock.equals(Blocks.f_50749_)) {
                chosenFeature = (ConfiguredFeature)ModConfiguredFeatures.JUNGLE_SOLITARY_NEST.get();
            } else if ((double)r < (Double)ProductiveBeesConfig.WORLD_GEN.nestConfigs.get("nether_bee_nest").get() && (grownBlock.equals(Blocks.f_50700_) || grownBlock.equals(Blocks.f_50691_))) {
                ConfiguredFeature configuredFeature = chosenFeature = grownBlock.equals(Blocks.f_50700_) ? (ConfiguredFeature)ModConfiguredFeatures.CRIMSON_FUNGUS_BEES_GROW.get() : (ConfiguredFeature)ModConfiguredFeatures.WARPED_FUNGUS_BEES_GROW.get();
            }
            if (chosenFeature != null) {
                event.setFeature(Holder.m_205709_((Object)chosenFeature));
            }
        }
    }

    private static boolean hasFlowers(LevelAccessor pLevel, BlockPos pPos) {
        for (BlockPos blockpos : BlockPos.MutableBlockPos.m_121940_((BlockPos)pPos.m_7495_().m_122013_(2).m_122025_(2), (BlockPos)pPos.m_7494_().m_122020_(2).m_122030_(2))) {
            if (!pLevel.m_8055_(blockpos).m_204336_(BlockTags.f_13041_)) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void onWandererTradesEvent(WandererTradesEvent event) {
        event.getGenericTrades().add((trader, rand) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 10), ItemStack.f_41583_, new ItemStack((ItemLike)ModItems.STURDY_BEE_CAGE.get()), 1, 12, 6, 0.2f));
        event.getGenericTrades().add((trader, rand) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 24), ItemStack.f_41583_, new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation("productivebees", "spawn_egg_bumble_bee"))), 3, 12, 6, 0.2f));
    }

    @SubscribeEvent
    public static void onVillagerTradesEvent(VillagerTradesEvent event) {
        if (event.getType().equals(ModProfessions.BEEKEEPER.get())) {
            ((List)event.getTrades().get(1)).add((trader, rand) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42781_), ItemStack.f_41583_, new ItemStack((ItemLike)Items.f_42616_), 1, 12, 6, 0.2f));
            ((List)event.getTrades().get(1)).add((trader, rand) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_), ItemStack.f_41583_, new ItemStack((ItemLike)Items.f_42590_, 4), 1, 32, 3, 0.2f));
            ((List)event.getTrades().get(1)).add((trader, rand) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 3), ItemStack.f_41583_, new ItemStack((ItemLike)Items.f_42574_), 3, 12, 3, 0.2f));
            ((List)event.getTrades().get(2)).add((trader, rand) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42787_, 2), ItemStack.f_41583_, new ItemStack((ItemLike)Items.f_42616_), 3, 10, 6, 0.2f));
            ((List)event.getTrades().get(2)).add((trader, rand) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_), ItemStack.f_41583_, new ItemStack((ItemLike)ModItems.BEE_CAGE.get(), 4), 3, 64, 6, 0.2f));
            ((List)event.getTrades().get(2)).add((trader, rand) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 2), ItemStack.f_41583_, new ItemStack((ItemLike)ModItems.SUGARBAG_HONEYCOMB.get()), 3, 32, 3, 0.2f));
            ((List)event.getTrades().get(2)).add((trader, rand) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_), ItemStack.f_41583_, new ItemStack((ItemLike)ModItems.TREAT_ON_A_STICK.get()), 3, 8, 3, 0.2f));
            ((List)event.getTrades().get(2)).add((trader, rand) -> {
                if (rand.m_188499_()) {
                    return new MerchantOffer(new ItemStack((ItemLike)ModItems.HONEY_TREAT.get(), 4), ItemStack.f_41583_, new ItemStack((ItemLike)Items.f_42616_), 3, 50, 3, 0.2f);
                }
                return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_), ItemStack.f_41583_, new ItemStack((ItemLike)ModItems.HONEY_TREAT.get(), 2), 3, 100, 3, 0.2f);
            });
            ((List)event.getTrades().get(3)).add((trader, rand) -> {
                Block hive = (Block)ModBlocks.ADVANCED_OAK_BEEHIVE.get();
                if (trader instanceof Villager) {
                    Villager villager = (Villager)trader;
                    VillagerType villagertype = villager.m_7141_().m_35560_();
                    if (villagertype.equals(VillagerType.f_35820_)) {
                        hive = (Block)ModBlocks.ADVANCED_JUNGLE_BEEHIVE.get();
                    } else if (villagertype.equals(VillagerType.f_35822_)) {
                        hive = (Block)ModBlocks.ADVANCED_ACACIA_BEEHIVE.get();
                    } else if (villagertype.equals(VillagerType.f_35819_)) {
                        hive = (Block)ModBlocks.ADVANCED_BIRCH_BEEHIVE.get();
                    } else if (villagertype.equals(VillagerType.f_35824_)) {
                        hive = (Block)ModBlocks.ADVANCED_DARK_OAK_BEEHIVE.get();
                    } else if (villagertype.equals(VillagerType.f_35825_) || villagertype.equals(VillagerType.f_35823_)) {
                        hive = (Block)ModBlocks.ADVANCED_SPRUCE_BEEHIVE.get();
                    }
                }
                return new MerchantOffer(new ItemStack((ItemLike)Items.f_42786_, 1), new ItemStack((ItemLike)Items.f_42616_, 6), new ItemStack((ItemLike)hive), 1, 12, 6, 0.2f);
            });
            ((List)event.getTrades().get(3)).add((trader, rand) -> {
                Block box = (Block)ModBlocks.EXPANSION_BOX_OAK.get();
                if (trader instanceof Villager) {
                    Villager villager = (Villager)trader;
                    VillagerType villagertype = villager.m_7141_().m_35560_();
                    if (villagertype.equals(VillagerType.f_35820_)) {
                        box = (Block)ModBlocks.EXPANSION_BOX_JUNGLE.get();
                    } else if (villagertype.equals(VillagerType.f_35822_)) {
                        box = (Block)ModBlocks.EXPANSION_BOX_ACACIA.get();
                    } else if (villagertype.equals(VillagerType.f_35819_)) {
                        box = (Block)ModBlocks.EXPANSION_BOX_BIRCH.get();
                    } else if (villagertype.equals(VillagerType.f_35824_)) {
                        box = (Block)ModBlocks.EXPANSION_BOX_DARK_OAK.get();
                    } else if (villagertype.equals(VillagerType.f_35825_) || villagertype.equals(VillagerType.f_35823_)) {
                        box = (Block)ModBlocks.EXPANSION_BOX_SPRUCE.get();
                    }
                }
                return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 4), ItemStack.f_41583_, new ItemStack((ItemLike)box), 1, 12, 6, 0.2f);
            });
            ((List)event.getTrades().get(4)).add((trader, rand) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 12), new ItemStack((ItemLike)ModItems.BEE_CAGE.get(), 1), new ItemStack((ItemLike)ModItems.STURDY_BEE_CAGE.get()), 3, 12, 6, 0.2f));
            ((List)event.getTrades().get(4)).add((trader, rand) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 6), ItemStack.f_41583_, new ItemStack((ItemLike)ModBlocks.JAR.get(), 1), 2, 12, 8, 0.2f));
            ((List)event.getTrades().get(5)).add((trader, rand) -> {
                ItemStack nest = new ItemStack((ItemLike)Items.f_42785_);
                try {
                    CompoundTag tag = nest.m_41784_();
                    CompoundTag bees = TagParser.m_129359_((String)"{Bees:[{EntityData:{id:\"minecraft:bee\"},TicksInHive:0,MinOccupationTicks:0}]}");
                    tag.m_128365_("BlockEntityTag", (Tag)bees);
                }
                catch (CommandSyntaxException e) {
                    ProductiveBees.LOGGER.warn("Failed to put bees into the beekeepers nests :(" + e.getMessage());
                }
                return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 32), ItemStack.f_41583_, nest, 1, 3, 16, 0.2f);
            });
            ((List)event.getTrades().get(5)).add((trader, rand) -> {
                Item egg = switch (rand.m_188503_(7)) {
                    case 0 -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("productivebees", "spawn_egg_quarry_bee"));
                    case 1 -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("productivebees", "spawn_egg_rancher_bee"));
                    case 2 -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("productivebees", "spawn_egg_farmer_bee"));
                    case 3 -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("productivebees", "spawn_egg_cupid_bee"));
                    case 4 -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("productivebees", "spawn_egg_hoarder_bee"));
                    case 5 -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("productivebees", "spawn_egg_dye_bee"));
                    default -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("productivebees", "spawn_egg_lumber_bee"));
                };
                return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 24), ItemStack.f_41583_, new ItemStack((ItemLike)egg), 3, 12, 6, 0.2f);
            });
        }
    }

    @SubscribeEvent
    public static void entityRightClicked(PlayerInteractEvent.EntityInteract entityInteract) {
        Level world;
        ItemStack itemStack = entityInteract.getItemStack();
        Entity entity = entityInteract.getTarget();
        if (!itemStack.m_41619_() && entity instanceof Bee && (world = entityInteract.getLevel()) instanceof ServerLevel) {
            Player player = entityInteract.getEntity();
            BlockPos pos = entity.m_20183_();
            Entity newBee = BeeHelper.itemInteract((Bee)entity, itemStack, (ServerLevel)world, entity.serializeNBT(), player);
            if (newBee instanceof Bee) {
                world.m_7106_((ParticleOptions)ParticleTypes.f_123759_, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), 0.2, 0.1, 0.2);
                world.m_6263_(player, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11698_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                world.m_7967_(newBee);
                if (((Bee)entity).m_21523_()) {
                    ((Bee)entity).m_21455_(true, true);
                }
                entity.m_146870_();
            }
        }
    }

    @SubscribeEvent
    public static void cocoaBreakSpawn(BlockEvent.BreakEvent event) {
        if (event.getState().m_60734_().equals(Blocks.f_50262_) && (Integer)event.getState().m_61143_((Property)CocoaBlock.f_51736_) == 2) {
            Player player = event.getPlayer();
            Level level = player.f_19853_;
            if (level instanceof ServerLevel && player instanceof ServerPlayer && (double)level.f_46441_.m_188501_() < (Double)ProductiveBeesConfig.BEES.sugarbagBeeChance.get()) {
                ConfigurableBee bee = (ConfigurableBee)((EntityType)ModEntities.CONFIGURABLE_BEE.get()).m_20615_(level);
                BlockPos pos = event.getPos();
                if (bee != null && BeeReloadListener.INSTANCE.getData("productivebees:sugarbag") != null) {
                    bee.setBeeType("productivebees:sugarbag");
                    bee.setAttributes();
                    bee.m_7678_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5, bee.m_146908_(), bee.m_146909_());
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123759_, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), 0.2, 0.1, 0.2);
                    level.m_5594_(player, pos, SoundEvents.f_11698_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    level.m_7967_((Entity)bee);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityAttributeCreate(EntityAttributeCreationEvent event) {
        EntityType bee;
        for (RegistryObject registryObject : ModEntities.HIVE_BEES.getEntries()) {
            bee = (EntityType)registryObject.get();
            event.put(bee, Bee.m_27858_().m_22265_());
        }
        for (RegistryObject registryObject : ModEntities.SOLITARY_BEES.getEntries()) {
            bee = (EntityType)registryObject.get();
            if (bee.m_20675_().contains("blue_banded_bee")) continue;
            event.put(bee, Bee.m_27858_().m_22265_());
        }
        event.put((EntityType)ModEntities.BLUE_BANDED_BEE.get(), BlueBandedBee.getDefaultAttributes().m_22265_());
    }

    @SubscribeEvent
    public static void fuelValues(FurnaceFuelBurnTimeEvent event) {
        Item item = event.getItemStack().m_41720_();
        if (item.equals(ModItems.WAX.get())) {
            event.setBurnTime(100);
        } else if (item.equals(((Block)ModBlocks.WAX_BLOCK.get()).m_5456_())) {
            event.setBurnTime(900);
        }
    }

    @SubscribeEvent
    public static void onItemFished(ItemFishedEvent event) {
        Player player = event.getEntity();
        if (player != null) {
            BlockPos pos = event.getHookEntity().m_20183_();
            Biome fishingBiome = (Biome)player.f_19853_.m_204166_(pos).m_203334_();
            ArrayList<BeeFishingRecipe> possibleRecipes = new ArrayList<BeeFishingRecipe>();
            List<BeeFishingRecipe> recipes = BeeFishingRecipe.getRecipeList(fishingBiome, player.f_19853_);
            if (!recipes.isEmpty()) {
                for (BeeFishingRecipe recipe : recipes) {
                    boolean willSpawn = player.f_19853_.f_46441_.m_188500_() < recipe.chance;
                    int fishingLuck = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44953_, (ItemStack)player.m_21205_());
                    for (int i = 0; i < 1 + fishingLuck; ++i) {
                        willSpawn = willSpawn || player.f_19853_.f_46441_.m_188500_() < recipe.chance;
                    }
                    if (!willSpawn) continue;
                    possibleRecipes.add(recipe);
                }
            }
            if (!possibleRecipes.isEmpty()) {
                BeeFishingRecipe chosenRecipe = (BeeFishingRecipe)possibleRecipes.get(player.f_19853_.f_46441_.m_188503_(possibleRecipes.size()));
                BeeIngredient beeIngredient = (BeeIngredient)chosenRecipe.output.get();
                Bee bee = (Bee)beeIngredient.getBeeEntity().m_20615_(player.f_19853_);
                if (bee != null) {
                    if (bee instanceof ConfigurableBee) {
                        ConfigurableBee configBee = (ConfigurableBee)bee;
                        configBee.setBeeType(beeIngredient.getBeeType().toString());
                        configBee.setAttributes();
                    }
                    bee.m_7678_((double)pos.m_123341_() + 0.5, (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + 0.5, bee.m_146908_(), bee.m_146909_());
                    player.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123759_, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), 0.2, 0.1, 0.2);
                    player.f_19853_.m_5594_(player, pos, SoundEvents.f_11741_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    player.f_19853_.m_7967_((Entity)bee);
                    bee.m_6710_((LivingEntity)player);
                    ModAdvancements.FISH_BEE.trigger((ServerPlayer)player, bee);
                }
            }
        }
    }

    @SubscribeEvent
    public void registerCaps(RegisterCapabilitiesEvent event) {
        event.register(IInhabitantStorage.class);
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        Iterator<Entity> iter = JarBlockItemRenderer.beeEntities.values().iterator();
        while (iter.hasNext()) {
            Entity bee = iter.next();
            ++bee.f_19797_;
            if (bee.f_19797_ % 6120 != 0) continue;
            iter.remove();
        }
    }
}

