/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.features.model;

import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Predicate;
import me.jellysquid.mods.sodium.mixin.features.model.SimpleBakedModelAccessor;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.MultiPartBakedModel;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.MultipartModelData;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MultiPartBakedModel.class})
public class MixinMultipartBakedModel {
    private final Map<BlockState, BakedModel[]> stateCacheFast = new Reference2ReferenceOpenHashMap();
    private final StampedLock lock = new StampedLock();
    @Shadow
    @Final
    private List<Pair<Predicate<BlockState>, BakedModel>> f_119459_;
    @Unique
    private boolean embeddium$hasCustomRenderTypes;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void checkSubModelRenderTypes(CallbackInfo ci) {
        Pair<Predicate<BlockState>, BakedModel> pair;
        BakedModel model;
        boolean hasRenderTypes = false;
        Iterator<Pair<Predicate<BlockState>, BakedModel>> iterator = this.f_119459_.iterator();
        while (iterator.hasNext() && !(hasRenderTypes = (model = (BakedModel)(pair = iterator.next()).getRight()).getClass() == SimpleBakedModel.class ? ((SimpleBakedModelAccessor)model).getBlockRenderTypes() != null : true)) {
        }
        this.embeddium$hasCustomRenderTypes = hasRenderTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Unique
    private BakedModel[] getModelComponents(BlockState state) {
        BakedModel[] models;
        long readStamp = this.lock.readLock();
        try {
            models = this.stateCacheFast.get(state);
        }
        finally {
            this.lock.unlockRead(readStamp);
        }
        if (models == null) {
            long writeStamp = this.lock.writeLock();
            try {
                ArrayList<BakedModel> modelList = new ArrayList<BakedModel>(this.f_119459_.size());
                for (Pair<Predicate<BlockState>, BakedModel> pair : this.f_119459_) {
                    if (!((Predicate)pair.getLeft()).test(state)) continue;
                    modelList.add((BakedModel)pair.getRight());
                }
                models = (BakedModel[])modelList.toArray(BakedModel[]::new);
                this.stateCacheFast.put(state, models);
            }
            finally {
                this.lock.unlockWrite(writeStamp);
            }
        }
        return models;
    }

    @Overwrite(remap=false)
    public List<BakedQuad> getQuads(BlockState state, Direction face, RandomSource random, ModelData modelData, RenderType renderLayer) {
        if (state == null) {
            return Collections.emptyList();
        }
        BakedModel[] models = this.getModelComponents(state);
        List<BakedQuad> quads = null;
        long seed = random.m_188505_();
        boolean checkSubmodelTypes = this.embeddium$hasCustomRenderTypes;
        for (BakedModel model : models) {
            random.m_188584_(seed);
            if (checkSubmodelTypes && renderLayer != null && !model.getRenderTypes(state, random, modelData).contains(renderLayer)) continue;
            List submodelQuads = model.getQuads(state, face, random, MultipartModelData.resolve((ModelData)modelData, (BakedModel)model), renderLayer);
            if (models.length == 1) {
                return submodelQuads;
            }
            if (quads == null) {
                quads = new ArrayList<BakedQuad>();
            }
            quads.addAll(submodelQuads);
        }
        return quads != null ? quads : Collections.emptyList();
    }

    @Overwrite(remap=false)
    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource random, @NotNull ModelData data) {
        long seed = random.m_188505_();
        if (!this.embeddium$hasCustomRenderTypes) {
            return ItemBlockRenderTypes.getRenderLayers((BlockState)state);
        }
        BakedModel[] models = this.getModelComponents(state);
        if (models.length == 0) {
            return ChunkRenderTypeSet.none();
        }
        ChunkRenderTypeSet[] sets = new ChunkRenderTypeSet[models.length];
        for (int i = 0; i < models.length; ++i) {
            random.m_188584_(seed);
            sets[i] = models[i].getRenderTypes(state, random, data);
        }
        return ChunkRenderTypeSet.union((ChunkRenderTypeSet[])sets);
    }
}

