/*
 * Decompiled with CFR 0.152.
 */
package appbot.block;

import appbot.AppliedBotanics;
import appbot.ae2.ManaKey;
import appbot.mixins.ManaPoolBlockEntityAccessor;
import appeng.api.config.Actionable;
import appeng.api.networking.GridFlags;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKey;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageHelper;
import appeng.api.util.AECableType;
import appeng.hooks.ticking.TickHandler;
import appeng.me.helpers.BlockEntityNodeListener;
import appeng.me.helpers.IGridConnectedBlockEntity;
import com.google.common.primitives.Ints;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.common.block.block_entity.mana.ManaPoolBlockEntity;

public class FluixPoolBlockEntity
extends ManaPoolBlockEntity
implements IInWorldGridNodeHost,
IGridConnectedBlockEntity {
    private final ManaPoolBlockEntityAccessor mana = (ManaPoolBlockEntityAccessor)((Object)this);
    private final IManagedGridNode mainNode = GridHelper.createManagedNode((Object)((Object)this), (IGridNodeListener)BlockEntityNodeListener.INSTANCE).setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL}).setVisualRepresentation((ItemLike)AppliedBotanics.getInstance().fluixManaPool()).setInWorldNode(true).setExposedOnSides(EnumSet.complementOf(EnumSet.of(Direction.UP))).setTagName("proxy");
    private final IActionSource actionSource = IActionSource.ofMachine(() -> ((IManagedGridNode)this.mainNode).getNode());
    private boolean saving;
    private boolean setChangedQueued = false;

    public FluixPoolBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        super(pos, state);
    }

    public boolean isFull() {
        IGrid grid = this.getMainNode().getGrid();
        if (grid == null || !this.getMainNode().isActive()) {
            return true;
        }
        return grid.getStorageService().getInventory().insert(ManaKey.KEY, 1L, Actionable.SIMULATE, this.actionSource) == 0L;
    }

    public void receiveMana(int mana) {
        IGrid grid = this.getMainNode().getGrid();
        if (grid == null || !this.getMainNode().isActive()) {
            return;
        }
        MEStorage storage = grid.getStorageService().getInventory();
        boolean changed = false;
        if (mana > 0) {
            changed = StorageHelper.poweredInsert((IEnergySource)grid.getEnergyService(), (MEStorage)storage, (AEKey)ManaKey.KEY, (long)mana, (IActionSource)this.actionSource) != 0L;
        } else if (mana < 0) {
            boolean bl = changed = StorageHelper.poweredExtraction((IEnergySource)grid.getEnergyService(), (MEStorage)storage, (AEKey)ManaKey.KEY, (long)(-mana), (IActionSource)this.actionSource) != 0L;
        }
        if (changed) {
            this.m_6596_();
            this.markDispatchable();
        }
    }

    public int getCurrentMana() {
        IGrid grid = this.getMainNode().getGrid();
        if (grid == null || this.saving) {
            return this.mana.getMana();
        }
        if (!this.getMainNode().isActive()) {
            return 0;
        }
        return (int)grid.getStorageService().getInventory().extract(ManaKey.KEY, Integer.MAX_VALUE, Actionable.SIMULATE, this.actionSource);
    }

    public int getMaxMana() {
        long manaCap;
        IGrid grid = this.getMainNode().getGrid();
        if (grid == null || this.saving) {
            return super.getMaxMana();
        }
        int oldMana = this.mana.getMana();
        int oldManaCap = super.getMaxMana();
        if (this.getMainNode().isActive()) {
            MEStorage storage = grid.getStorageService().getInventory();
            this.mana.setMana((int)storage.extract(ManaKey.KEY, Integer.MAX_VALUE, Actionable.SIMULATE, this.actionSource));
            manaCap = storage.extract(ManaKey.KEY, Integer.MAX_VALUE, Actionable.SIMULATE, this.actionSource) + storage.insert(ManaKey.KEY, Integer.MAX_VALUE, Actionable.SIMULATE, this.actionSource);
        } else {
            this.mana.setMana(0);
            manaCap = 0L;
        }
        if (oldMana != this.mana.getMana() || (long)oldManaCap != manaCap) {
            this.m_6596_();
            this.markDispatchable();
        }
        return Ints.saturatedCast((long)manaCap);
    }

    public void m_183515_(CompoundTag tag) {
        try {
            this.saving = true;
            super.m_183515_(tag);
        }
        finally {
            this.saving = false;
        }
        this.getMainNode().saveToNBT(tag);
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.getMainNode().loadFromNBT(tag);
    }

    @Nullable
    public IGridNode getGridNode(Direction dir) {
        IGridNode node = this.getMainNode().getNode();
        return node != null && node.isExposedOnSide(dir) ? node : null;
    }

    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.SMART;
    }

    public IManagedGridNode getMainNode() {
        return this.mainNode;
    }

    public void securityBreak() {
        this.f_58857_.m_46961_(this.f_58858_, true);
    }

    public void saveChanges() {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.f_58857_.f_46443_) {
            this.m_6596_();
        } else {
            this.f_58857_.m_151543_(this.f_58858_);
            if (!this.setChangedQueued) {
                TickHandler.instance().addCallable(null, this::setChangedAtEndOfTick);
                this.setChangedQueued = true;
            }
        }
    }

    private void setChangedAtEndOfTick() {
        this.m_6596_();
        this.setChangedQueued = false;
    }

    public void onChunkUnloaded() {
        this.getMainNode().destroy();
    }

    public void onReady() {
        this.getMainNode().create(this.m_58904_(), this.m_58899_());
    }

    public void m_7651_() {
        super.m_7651_();
        this.getMainNode().destroy();
    }

    public void m_6339_() {
        super.m_6339_();
        GridHelper.onFirstTick((BlockEntity)this, FluixPoolBlockEntity::onReady);
    }

    public int calculateComparatorLevel() {
        long freeMana;
        long currentMana;
        IGrid grid = this.getMainNode().getGrid();
        if (grid == null) {
            currentMana = this.mana.getMana();
            freeMana = (long)super.getMaxMana() - currentMana;
        } else if (!this.getMainNode().isActive()) {
            currentMana = 0L;
            freeMana = 0L;
        } else {
            MEStorage storage = grid.getStorageService().getInventory();
            currentMana = storage.extract(ManaKey.KEY, Long.MAX_VALUE, Actionable.SIMULATE, this.actionSource);
            freeMana = storage.insert(ManaKey.KEY, Long.MAX_VALUE, Actionable.SIMULATE, this.actionSource);
        }
        if (currentMana == 0L) {
            return 0;
        }
        return (int)Math.ceil(1.0 / (1.0 + (double)freeMana / (double)currentMana) * 15.0);
    }
}

