/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.tab;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import sonar.fluxnetworks.api.FluxTranslate;
import sonar.fluxnetworks.api.energy.EnergyType;
import sonar.fluxnetworks.client.gui.tab.GuiTabSelection;
import sonar.fluxnetworks.common.connection.FluxMenu;
import sonar.fluxnetworks.common.connection.FluxNetwork;
import sonar.fluxnetworks.common.connection.NetworkStatistics;
import sonar.fluxnetworks.register.ClientMessages;

public class GuiTabDetailedSelection
extends GuiTabSelection {
    private int timer = 0;

    public GuiTabDetailedSelection(@Nonnull FluxMenu menu, @Nonnull Player player) {
        super(menu, player);
        this.mGridHeight = 20;
        this.mGridPerPage = 6;
        this.mElementWidth = 146;
        this.mElementHeight = 19;
    }

    @Override
    protected void renderBarAndName(PoseStack poseStack, FluxNetwork element, int x, int y, boolean selected) {
        this.blitF(poseStack, x, y, this.mElementWidth, this.mElementHeight, 0.0f, 448.0f, this.mElementWidth * 2, this.mElementHeight * 2);
        this.f_96547_.m_92883_(poseStack, element.getNetworkName(), (float)(x + 4), (float)(y + 2), selected ? 0xFFFFFF : 0x606060);
        poseStack.m_85836_();
        poseStack.m_85841_(0.75f, 0.75f, 1.0f);
        String text = "C: " + element.getStatistics().getConnectionCount();
        text = text + ", I: " + EnergyType.FE.getUsageCompact(element.getStatistics().energyInput);
        text = text + ", O: " + EnergyType.FE.getUsageCompact(element.getStatistics().energyOutput);
        text = text + ", T: " + element.getStatistics().averageTickMicro + " \u00b5s/t";
        this.f_96547_.m_92883_(poseStack, text, (float)((int)((double)(x + 4) / 0.75)), (float)((int)((double)(y + 11) / 0.75)), selected ? 0xFFFFFF : 0x808080);
        poseStack.m_85849_();
    }

    @Override
    protected List<Component> getElementTooltips(@Nonnull FluxNetwork element) {
        List<Component> components = super.getElementTooltips(element);
        NetworkStatistics stats = element.getStatistics();
        components.add((Component)FluxTranslate.PLUGS.makeComponent().m_130946_(ChatFormatting.GRAY + ": " + ChatFormatting.RESET + stats.fluxPlugCount));
        components.add((Component)FluxTranslate.POINTS.makeComponent().m_130946_(ChatFormatting.GRAY + ": " + ChatFormatting.RESET + stats.fluxPointCount));
        components.add((Component)FluxTranslate.STORAGES.makeComponent().m_130946_(ChatFormatting.GRAY + ": " + ChatFormatting.RESET + stats.fluxStorageCount));
        components.add((Component)FluxTranslate.CONTROLLERS.makeComponent().m_130946_(ChatFormatting.GRAY + ": " + ChatFormatting.RESET + stats.fluxControllerCount));
        components.add((Component)FluxTranslate.INPUT.makeComponent().m_130946_(ChatFormatting.GRAY + ": " + ChatFormatting.RESET + EnergyType.FE.getUsageCompact(stats.energyInput)));
        components.add((Component)FluxTranslate.OUTPUT.makeComponent().m_130946_(ChatFormatting.GRAY + ": " + ChatFormatting.RESET + EnergyType.FE.getUsageCompact(stats.energyOutput)));
        components.add((Component)FluxTranslate.BUFFER.makeComponent().m_130946_(ChatFormatting.GRAY + ": " + ChatFormatting.RESET + EnergyType.FE.getStorageCompact(stats.totalBuffer)));
        components.add((Component)FluxTranslate.ENERGY.makeComponent().m_130946_(ChatFormatting.GRAY + ": " + ChatFormatting.RESET + EnergyType.FE.getStorageCompact(stats.totalEnergy)));
        components.add((Component)FluxTranslate.AVERAGE_TICK.makeComponent().m_130946_(": " + stats.averageTickMicro + " \u00b5s/t"));
        return components;
    }

    @Override
    protected void m_181908_() {
        super.m_181908_();
        if (this.timer == 0) {
            ClientMessages.updateNetwork(this.getToken(), this.mCurrent, (byte)24);
        }
        this.timer = (this.timer + 1) % 20;
    }
}

