/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.block;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import sonar.fluxnetworks.common.block.FluxDeviceBlock;
import sonar.fluxnetworks.common.device.TileFluxConnector;
import sonar.fluxnetworks.common.util.FluxUtils;

@ParametersAreNonnullByDefault
public abstract class FluxConnectorBlock
extends FluxDeviceBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty[] SIDES_CONNECTED = new BooleanProperty[]{BlockStateProperties.f_61367_, BlockStateProperties.f_61366_, BlockStateProperties.f_61368_, BlockStateProperties.f_61370_, BlockStateProperties.f_61371_, BlockStateProperties.f_61369_};

    protected FluxConnectorBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)BlockStateProperties.f_61367_, (Comparable)Boolean.FALSE)).m_61124_((Property)BlockStateProperties.f_61366_, (Comparable)Boolean.FALSE)).m_61124_((Property)BlockStateProperties.f_61368_, (Comparable)Boolean.FALSE)).m_61124_((Property)BlockStateProperties.f_61370_, (Comparable)Boolean.FALSE)).m_61124_((Property)BlockStateProperties.f_61371_, (Comparable)Boolean.FALSE)).m_61124_((Property)BlockStateProperties.f_61369_, (Comparable)Boolean.FALSE)).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.FALSE));
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        BlockEntity blockEntity;
        super.m_6861_(state, level, pos, block, fromPos, isMoving);
        if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof TileFluxConnector) {
            TileFluxConnector c = (TileFluxConnector)blockEntity;
            Direction dir = FluxUtils.getBlockDirection(pos, fromPos);
            if (dir != null) {
                c.updateSideTransfer(dir, level.m_7702_(fromPos));
            }
        }
    }

    public void onNeighborChange(BlockState state, LevelReader level, BlockPos pos, BlockPos neighbor) {
        BlockEntity blockEntity;
        super.onNeighborChange(state, level, pos, neighbor);
        if (!level.m_5776_() && (blockEntity = level.m_7702_(pos)) instanceof TileFluxConnector) {
            TileFluxConnector c = (TileFluxConnector)blockEntity;
            Direction dir = FluxUtils.getBlockDirection(pos, neighbor);
            if (dir != null) {
                c.updateSideTransfer(dir, level.m_7702_(neighbor));
            }
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_));
    }

    @Nonnull
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_((Property[])SIDES_CONNECTED);
        builder.m_61104_(new Property[]{BlockStateProperties.f_61362_});
    }

    @Nonnull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }
}

