/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.ability;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.conditions.FalseCondition;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.registries.ForgeRegistries;
import org.cyclops.everlastingabilities.EverlastingAbilities;
import org.cyclops.everlastingabilities.GeneralConfig;
import org.cyclops.everlastingabilities.RegistryEntries;
import org.cyclops.everlastingabilities.api.AbilityTypeAdapter;
import org.cyclops.everlastingabilities.api.IAbilityType;

public class AbilityTypeEffect
extends AbilityTypeAdapter {
    private final Target target;
    private final boolean targetsFriendlyMobs;
    private final double radiusFactor;
    private final String effectId;
    private final MobEffect potion;
    private final int tickModulus;
    private final double amplifierFactor;
    private final boolean levelBasedDuration;
    private final double durationFactor;

    public AbilityTypeEffect(ICondition condition, String name, Rarity rarity, int maxLevel, int baseXpPerLevel, boolean obtainableOnPlayerSpawn, boolean obtainableOnMobSpawn, boolean obtainableOnCraft, boolean obtainableOnLoot, Target target, boolean targetsFriendlyMobs, double radiusFactor, String effectId, int tickModulus, double amplifierFactor, boolean levelBasedDuration, double durationFactor) {
        super(condition, name, rarity, maxLevel, baseXpPerLevel, obtainableOnPlayerSpawn, obtainableOnMobSpawn, obtainableOnCraft, obtainableOnLoot);
        this.target = target;
        this.targetsFriendlyMobs = targetsFriendlyMobs;
        this.radiusFactor = radiusFactor;
        this.effectId = effectId;
        this.potion = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(effectId));
        if (this.potion == null) {
            EverlastingAbilities.clog(org.apache.logging.log4j.Level.INFO, "No potion effect was found with id: " + effectId + ". Marking as disabled.");
            this.setCondition((ICondition)FalseCondition.INSTANCE);
        }
        this.tickModulus = tickModulus;
        this.amplifierFactor = amplifierFactor;
        this.levelBasedDuration = levelBasedDuration;
        this.durationFactor = durationFactor;
    }

    public Target getTarget() {
        return this.target;
    }

    public boolean isTargetsFriendlyMobs() {
        return this.targetsFriendlyMobs;
    }

    public double getRadiusFactor() {
        return this.radiusFactor;
    }

    public String getEffectId() {
        return this.effectId;
    }

    public int getTickModulus() {
        return this.tickModulus;
    }

    public double getAmplifierFactor() {
        return this.amplifierFactor;
    }

    public boolean isLevelBasedDuration() {
        return this.levelBasedDuration;
    }

    public double getDurationFactor() {
        return this.durationFactor;
    }

    @Override
    public Codec<? extends IAbilityType> codec() {
        return Objects.requireNonNull(RegistryEntries.ABILITYSERIALIZER_EFFECT);
    }

    protected int getDuration(int tickModulus, int level) {
        if (this.isLevelBasedDuration()) {
            int maxLevel = this.getMaxLevel() == -1 ? 5 : this.getMaxLevel();
            return (int)((double)(20.0f * ((float)level / (float)maxLevel * 20.0f)) * this.getDurationFactor());
        }
        return (int)((double)tickModulus * this.getDurationFactor());
    }

    protected int getTickModulus(int level) {
        return this.getTickModulus();
    }

    protected int getAmplifier(int level) {
        return (int)((double)(level - 1) * this.getAmplifierFactor());
    }

    @Override
    public void onTick(Player player, int level) {
        Level world = player.f_19853_;
        if (this.potion != null && !world.f_46443_ && player.f_19853_.m_46467_() % (long)this.getTickModulus(level) == 0L) {
            switch (this.getTarget()) {
                case SELF: {
                    player.m_7292_(new MobEffectInstance(this.potion, this.getDuration(this.getTickModulus(level), level), this.getAmplifier(level), true, GeneralConfig.showPotionEffectParticles));
                    break;
                }
                case RADIUS: {
                    double radius = (double)level * this.getRadiusFactor();
                    List mobs = world.m_6443_(LivingEntity.class, player.m_20191_().m_82377_(radius, radius, radius), EntitySelector.f_20408_);
                    for (LivingEntity mob : mobs) {
                        if (mob == player || !this.targetsFriendlyMobs && AbilityTypeEffect.isFriendlyMob(mob, player)) continue;
                        mob.m_7292_(new MobEffectInstance(this.potion, this.getDuration(this.getTickModulus(level), level), this.getAmplifier(level), true, GeneralConfig.showPotionEffectParticles));
                    }
                    break;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isFriendlyMob(LivingEntity mob, Player player) {
        ResourceLocation resourceLocation = mob instanceof Player ? new ResourceLocation("player") : ForgeRegistries.ENTITY_TYPES.getKey((Object)mob.m_6095_());
        String mobName = resourceLocation == null ? "null" : resourceLocation.toString();
        if (player.m_7307_((Entity)mob)) return true;
        if (mob instanceof TamableAnimal) {
            if (((TamableAnimal)mob).m_21826_() == player) return true;
        }
        if (!GeneralConfig.friendlyMobs.stream().anyMatch(mobName::matches)) return false;
        return true;
    }

    public static enum Target {
        SELF,
        RADIUS;

    }
}

