/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.api;

import com.mojang.serialization.Codec;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Rarity;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.TrueCondition;
import org.cyclops.everlastingabilities.api.AbilityTypeAdapter;
import org.cyclops.everlastingabilities.api.IAbilityType;

public class Ability
implements Comparable<Ability> {
    public static final Ability EMPTY = new Ability(new AbilityTypeAdapter((ICondition)TrueCondition.INSTANCE, "", Rarity.COMMON, 0, 0, true, true, true, true){

        @Override
        public Codec<? extends IAbilityType> codec() {
            return null;
        }
    }, 0);
    private final IAbilityType abilityType;
    private final int level;

    public Ability(@Nonnull IAbilityType abilityType, int level) {
        this.abilityType = Objects.requireNonNull(abilityType);
        this.level = level;
    }

    public IAbilityType getAbilityType() {
        return this.abilityType;
    }

    public int getLevel() {
        return this.level;
    }

    public String toString() {
        return String.format("[%s @ %s]", this.abilityType.getTranslationKey(), this.level);
    }

    @Override
    public int compareTo(Ability other) {
        return this.toString().compareTo(other.toString());
    }

    public Component getTextComponent() {
        return Component.m_237113_((String)"[").m_7220_((Component)Component.m_237115_((String)this.abilityType.getTranslationKey())).m_130946_(" @ " + this.level + "]");
    }

    public boolean isEmpty() {
        return this.getLevel() <= 0;
    }
}

