/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.core;

import com.mojang.brigadier.CommandDispatcher;
import fuzs.puzzleslib.api.biome.v1.BiomeLoadingContext;
import fuzs.puzzleslib.api.biome.v1.BiomeLoadingPhase;
import fuzs.puzzleslib.api.biome.v1.BiomeModificationContext;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;

public interface ModConstructor {
    default public void onConstructMod() {
    }

    @Deprecated(forRemoval=true)
    default public void onCommonSetup() {
    }

    default public void onCommonSetup(ModLifecycleContext context) {
        this.onCommonSetup();
    }

    default public void onRegisterSpawnPlacements(SpawnPlacementsContext context) {
    }

    default public void onEntityAttributeCreation(EntityAttributesCreateContext context) {
    }

    default public void onEntityAttributeModification(EntityAttributesModifyContext context) {
    }

    default public void onRegisterFuelBurnTimes(FuelBurnTimesContext context) {
    }

    @Deprecated(forRemoval=true)
    default public void onRegisterCommands(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context, Commands.CommandSelection environment) {
    }

    default public void onRegisterCommands(RegisterCommandsContext context) {
        this.onRegisterCommands(context.dispatcher(), context.context(), context.environment());
    }

    default public void onLootTableReplacement(LootTablesReplaceContext context) {
    }

    default public void onLootTableModification(LootTablesModifyContext context) {
    }

    default public void onRegisterBiomeModifications(BiomeModificationsContext context) {
    }

    default public void onRegisterFlammableBlocks(FlammableBlocksContext context) {
    }

    public record RegisterCommandsContext(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context, Commands.CommandSelection environment) {
    }

    @FunctionalInterface
    public static interface FlammableBlocksContext {
        public void registerFlammable(int var1, int var2, Block ... var3);
    }

    @FunctionalInterface
    public static interface BiomeModificationsContext {
        public void register(BiomeLoadingPhase var1, Predicate<BiomeLoadingContext> var2, Consumer<BiomeModificationContext> var3);
    }

    public static abstract class LootTablesModifyContext
    extends LootTablesContext {
        public LootTablesModifyContext(LootTables lootManager, ResourceLocation id) {
            super(lootManager, id);
        }

        public abstract void addLootPool(LootPool var1);

        public abstract boolean removeLootPool(int var1);
    }

    public static abstract class LootTablesReplaceContext
    extends LootTablesContext {
        private final LootTable original;

        public LootTablesReplaceContext(LootTables lootManager, ResourceLocation id, LootTable original) {
            super(lootManager, id);
            this.original = original;
        }

        public LootTable getLootTable() {
            return this.original;
        }

        public abstract void setLootTable(LootTable var1);
    }

    public static abstract class LootTablesContext {
        private final LootTables lootManager;
        private final ResourceLocation id;

        protected LootTablesContext(LootTables lootManager, ResourceLocation id) {
            this.lootManager = lootManager;
            this.id = id;
        }

        public final LootTables getLootManager() {
            return this.lootManager;
        }

        public final ResourceLocation getId() {
            return this.id;
        }
    }

    @FunctionalInterface
    public static interface FuelBurnTimesContext {
        public void registerFuel(int var1, ItemLike ... var2);

        @Deprecated(forRemoval=true)
        default public void registerFuelItem(Item item, int burnTime) {
            this.registerFuel(burnTime, new ItemLike[]{item});
        }

        @Deprecated(forRemoval=true)
        default public void registerFuelBlock(Block block, int burnTime) {
            this.registerFuel(burnTime, new ItemLike[]{block});
        }

        @Deprecated(forRemoval=true)
        default public void registerWoodenBlock(Block block) {
            this.registerFuelBlock(block, block instanceof SlabBlock ? 150 : 300);
        }
    }

    @FunctionalInterface
    public static interface EntityAttributesModifyContext {
        default public void registerAttributeModification(EntityType<? extends LivingEntity> type, Attribute attribute) {
            this.registerAttributeModification(type, attribute, attribute.m_22082_());
        }

        public void registerAttributeModification(EntityType<? extends LivingEntity> var1, Attribute var2, double var3);
    }

    @FunctionalInterface
    public static interface EntityAttributesCreateContext {
        public void registerEntityAttributes(EntityType<? extends LivingEntity> var1, AttributeSupplier.Builder var2);
    }

    @FunctionalInterface
    public static interface SpawnPlacementsContext {
        public <T extends Mob> void registerSpawnPlacement(EntityType<T> var1, SpawnPlacements.Type var2, Heightmap.Types var3, SpawnPlacements.SpawnPredicate<T> var4);
    }

    public static interface ModLifecycleContext {
        public void enqueueWork(Runnable var1);
    }
}

