/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.biome;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.mojang.serialization.Codec;
import fuzs.puzzleslib.api.biome.v1.BiomeLoadingContext;
import fuzs.puzzleslib.api.biome.v1.BiomeLoadingPhase;
import fuzs.puzzleslib.api.biome.v1.BiomeModificationContext;
import fuzs.puzzleslib.impl.biome.BiomeLoadingContextForge;
import fuzs.puzzleslib.impl.biome.ClimateSettingsContextForge;
import fuzs.puzzleslib.impl.biome.GenerationSettingsContextForge;
import fuzs.puzzleslib.impl.biome.MobSpawnSettingsContextForge;
import fuzs.puzzleslib.impl.biome.SpecialEffectsContextForge;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

public class BiomeLoadingHandler {
    private static final Map<BiomeModifier.Phase, BiomeLoadingPhase> BIOME_MODIFIER_PHASE_CONVERSIONS = Maps.immutableEnumMap((Map)new HashMap<BiomeModifier.Phase, BiomeLoadingPhase>(){
        {
            this.put(BiomeModifier.Phase.ADD, BiomeLoadingPhase.ADDITIONS);
            this.put(BiomeModifier.Phase.REMOVE, BiomeLoadingPhase.REMOVALS);
            this.put(BiomeModifier.Phase.MODIFY, BiomeLoadingPhase.MODIFICATIONS);
            this.put(BiomeModifier.Phase.AFTER_EVERYTHING, BiomeLoadingPhase.POST_PROCESSING);
        }
    });

    public static void register(String modId, IEventBus modEventBus, Multimap<BiomeLoadingPhase, BiomeModificationData> biomeLoadingEntries) {
        DeferredRegister biomeModifiersRegistry = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (String)modId);
        DeferredRegister biomeModifierSerializersRegistry = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)modId);
        biomeModifiersRegistry.register(modEventBus);
        biomeModifierSerializersRegistry.register(modEventBus);
        BiomeModifierImpl biomeModifier = new BiomeModifierImpl(biomeLoadingEntries);
        biomeModifierSerializersRegistry.register("biome_modifiers_codec", () -> biomeModifier.codec());
        biomeModifiersRegistry.register("biome_modifiers", () -> biomeModifier);
    }

    private static BiomeModificationContext getBiomeModificationContext(ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        ClimateSettingsContextForge climateSettings = new ClimateSettingsContextForge(builder.getClimateSettings());
        SpecialEffectsContextForge specialEffects = new SpecialEffectsContextForge(builder.getSpecialEffects());
        GenerationSettingsContextForge generationSettings = GenerationSettingsContextForge.create(builder.getGenerationSettings());
        MobSpawnSettingsContextForge mobSpawnSettings = new MobSpawnSettingsContextForge(builder.getMobSpawnSettings());
        return new BiomeModificationContext(climateSettings, specialEffects, generationSettings, mobSpawnSettings);
    }

    private static class BiomeModifierImpl
    implements BiomeModifier {
        private final Codec<? extends BiomeModifier> codec = Codec.unit((Object)this);
        private final Multimap<BiomeLoadingPhase, BiomeModificationData> biomeLoadingEntries;

        public BiomeModifierImpl(Multimap<BiomeLoadingPhase, BiomeModificationData> biomeLoadingEntries) {
            this.biomeLoadingEntries = biomeLoadingEntries;
        }

        public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
            Collection modifications;
            BiomeLoadingPhase loadingPhase = BIOME_MODIFIER_PHASE_CONVERSIONS.get(phase);
            if (loadingPhase != null && !(modifications = this.biomeLoadingEntries.get((Object)loadingPhase)).isEmpty()) {
                BiomeLoadingContext loadingContext = BiomeLoadingContextForge.create(biome);
                BiomeModificationContext modificationContext = BiomeLoadingHandler.getBiomeModificationContext(builder);
                for (BiomeModificationData modification : modifications) {
                    if (!modification.selector().test(loadingContext)) continue;
                    modification.modifier().accept(modificationContext);
                }
            }
        }

        public Codec<? extends BiomeModifier> codec() {
            return this.codec;
        }
    }

    public record BiomeModificationData(BiomeLoadingPhase phase, Predicate<BiomeLoadingContext> selector, Consumer<BiomeModificationContext> modifier) {
    }
}

