/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.serialization;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import net.darkhax.bookshelf.api.serialization.ISerializer;
import net.darkhax.bookshelf.api.serialization.NBTParseException;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

public final class SerializerShort
implements ISerializer<Short> {
    public static final ISerializer<Short> SERIALIZER = new SerializerShort();

    private SerializerShort() {
    }

    @Override
    public Short fromJSON(JsonElement json) {
        return json.getAsShort();
    }

    @Override
    public JsonElement toJSON(Short toWrite) {
        return new JsonPrimitive((Number)toWrite);
    }

    @Override
    public Short fromByteBuf(FriendlyByteBuf buffer) {
        return buffer.readShort();
    }

    @Override
    public void toByteBuf(FriendlyByteBuf buffer, Short toWrite) {
        buffer.writeShort((int)toWrite.shortValue());
    }

    @Override
    public Tag toNBT(Short toWrite) {
        return ShortTag.m_129258_((short)toWrite);
    }

    @Override
    public Short fromNBT(Tag nbt) {
        if (nbt instanceof NumericTag) {
            NumericTag shortTag = (NumericTag)nbt;
            return shortTag.m_7053_();
        }
        throw new NBTParseException("Expected NBT to be a number tag. Class was " + nbt.getClass() + " with ID " + nbt.m_7060_() + " instead.");
    }
}

