/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.util;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.reflect.Type;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraftforge.registries.ForgeRegistries;
import shadows.placebo.codec.PlaceboCodecs;
import shadows.placebo.util.StepFunction;

public record ChancedEffectInstance(float chance, MobEffect effect, StepFunction amplifier, boolean ambient, boolean visible) {
    public static Codec<ChancedEffectInstance> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)PlaceboCodecs.nullableField((Codec)Codec.floatRange((float)0.0f, (float)1.0f), (String)"chance", (Object)Float.valueOf(1.0f)).forGetter(ChancedEffectInstance::chance), (App)ForgeRegistries.MOB_EFFECTS.getCodec().fieldOf("effect").forGetter(ChancedEffectInstance::effect), (App)PlaceboCodecs.nullableField((Codec)StepFunction.CODEC, (String)"amplifier", (Object)StepFunction.constant((float)0.0f)).forGetter(ChancedEffectInstance::amplifier), (App)PlaceboCodecs.nullableField((Codec)Codec.BOOL, (String)"ambient", (Object)true).forGetter(ChancedEffectInstance::ambient), (App)PlaceboCodecs.nullableField((Codec)Codec.BOOL, (String)"visible", (Object)false).forGetter(ChancedEffectInstance::visible)).apply((Applicative)inst, ChancedEffectInstance::new));
    public static Codec<ChancedEffectInstance> CONSTANT_CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.unit((Object)Float.valueOf(1.0f)).optionalFieldOf("chance", (Object)Float.valueOf(1.0f)).forGetter(a -> Float.valueOf(1.0f)), (App)ForgeRegistries.MOB_EFFECTS.getCodec().fieldOf("effect").forGetter(ChancedEffectInstance::effect), (App)PlaceboCodecs.nullableField((Codec)Codec.intRange((int)0, (int)255), (String)"amplifier", (Object)0).xmap(StepFunction::constant, sf -> (int)sf.min()).forGetter(ChancedEffectInstance::amplifier), (App)PlaceboCodecs.nullableField((Codec)Codec.BOOL, (String)"ambient", (Object)true).forGetter(ChancedEffectInstance::ambient), (App)PlaceboCodecs.nullableField((Codec)Codec.BOOL, (String)"visible", (Object)false).forGetter(ChancedEffectInstance::visible)).apply((Applicative)inst, ChancedEffectInstance::new));

    @Deprecated(forRemoval=true)
    public float getChance() {
        return this.chance;
    }

    @Deprecated(forRemoval=true)
    public MobEffect getEffect() {
        return this.effect;
    }

    @Deprecated(forRemoval=true)
    public MobEffectInstance createInstance(RandomSource rand, int duration) {
        return this.create(rand, duration);
    }

    public MobEffectInstance create(RandomSource rand, int duration) {
        return new MobEffectInstance(this.effect, duration, this.amplifier.getInt(rand.m_188501_()), this.ambient, this.visible);
    }

    public MobEffectInstance createDeterministic(int duration) {
        return new MobEffectInstance(this.effect, duration, this.amplifier.getInt(0.0f), this.ambient, this.visible);
    }

    @Deprecated(forRemoval=true)
    public static class Deserializer
    implements JsonDeserializer<ChancedEffectInstance> {
        public ChancedEffectInstance deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            boolean visible;
            JsonObject obj = json.getAsJsonObject();
            float chance = obj.get("chance").getAsFloat();
            String _effect = obj.get("effect").getAsString();
            MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(_effect));
            if (effect == null) {
                throw new JsonParseException("Attempted to construct a ChancedEffectInstance with invalid effect: " + _effect);
            }
            boolean ambient = obj.has("ambient") ? obj.get("ambient").getAsBoolean() : true;
            boolean bl = visible = obj.has("visible") ? obj.get("visible").getAsBoolean() : false;
            if (obj.has("amplifier")) {
                int max;
                JsonObject range = obj.get("amplifier").getAsJsonObject();
                int min = range.get("min").getAsInt();
                StepFunction func = min == (max = range.get("max").getAsInt()) ? StepFunction.constant((float)min) : new StepFunction((float)min, max - min, 1.0f);
                return new ChancedEffectInstance(chance, effect, func, ambient, visible);
            }
            return new ChancedEffectInstance(chance, effect, StepFunction.constant((float)0.0f), ambient, visible);
        }
    }
}

