/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.storage;

import appeng.block.AEBaseEntityBlock;
import appeng.blockentity.storage.SkyChestBlockEntity;
import appeng.core.definitions.AEBlockEntities;
import appeng.menu.MenuOpener;
import appeng.menu.implementations.SkyChestMenu;
import appeng.menu.locator.MenuLocators;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SkyChestBlock
extends AEBaseEntityBlock<SkyChestBlockEntity>
implements SimpleWaterloggedBlock {
    private static final double AABB_OFFSET_BOTTOM = 0.0;
    private static final double AABB_OFFSET_SIDES = 0.06;
    private static final double AABB_OFFSET_TOP = 0.0625;
    private static final Map<Direction, VoxelShape> SHAPES = new EnumMap<Direction, VoxelShape>(Direction.class);
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public final SkyChestType type;

    public SkyChestBlock(SkyChestType type, BlockBehaviour.Properties props) {
        super(props);
        this.type = type;
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    @Override
    public InteractionResult onActivated(Level level, BlockPos pos, Player player, InteractionHand hand, @Nullable ItemStack heldItem, BlockHitResult hit) {
        SkyChestBlockEntity blockEntity;
        if (!level.m_5776_() && (blockEntity = (SkyChestBlockEntity)this.getBlockEntity((BlockGetter)level, pos)) != null) {
            blockEntity.unpackLootTable(player);
            MenuOpener.open(SkyChestMenu.TYPE, player, MenuLocators.forBlockEntity(blockEntity));
        }
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        level.m_141902_(pos, AEBlockEntities.SKY_CHEST).ifPresent(SkyChestBlockEntity::recheckOpen);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        SkyChestBlockEntity sk = (SkyChestBlockEntity)this.getBlockEntity(level, pos);
        Direction up = sk != null ? sk.getUp() : Direction.UP;
        return SHAPES.get(up);
    }

    private static AABB computeAABB(Direction up) {
        double offsetX = up.m_122429_() == 0 ? 0.06 : 0.0;
        double offsetY = up.m_122430_() == 0 ? 0.06 : 0.0;
        double offsetZ = up.m_122431_() == 0 ? 0.06 : 0.0;
        double minX = Math.max(0.0, offsetX + (up.m_122429_() < 0 ? 0.0 : (double)up.m_122429_() * 0.0625));
        double minY = Math.max(0.0, offsetY + (up.m_122430_() < 0 ? 0.0625 : (double)up.m_122430_() * 0.0));
        double minZ = Math.max(0.0, offsetZ + (up.m_122431_() < 0 ? 0.0 : (double)up.m_122431_() * 0.0625));
        double maxX = Math.min(1.0, 1.0 - offsetX - (up.m_122429_() < 0 ? 0.0625 : (double)up.m_122429_() * 0.0));
        double maxY = Math.min(1.0, 1.0 - offsetY - (up.m_122430_() < 0 ? 0.0 : (double)up.m_122430_() * 0.0625));
        double maxZ = Math.min(1.0, 1.0 - offsetZ - (up.m_122431_() < 0 ? 0.0625 : (double)up.m_122431_() * 0.0));
        return new AABB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        FluidState fluidState = context.m_43725_().m_6425_(pos);
        BlockState blockState = (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
        return blockState;
    }

    public FluidState m_5888_(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(blockState);
    }

    public BlockState m_7417_(BlockState blockState, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(blockState, facing, facingState, level, currentPos, facingPos);
    }

    public void m_5707_(Level level, BlockPos blockPos, BlockState state, Player player) {
        super.m_5707_(level, blockPos, state, player);
        level.m_141902_(blockPos, AEBlockEntities.SKY_CHEST).ifPresent(chest -> chest.unpackLootTable(player));
    }

    static {
        for (Direction up : Direction.values()) {
            AABB aabb = SkyChestBlock.computeAABB(up);
            SHAPES.put(up, Shapes.m_83064_((AABB)aabb));
        }
    }

    public static enum SkyChestType {
        STONE,
        BLOCK;

    }
}

