/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui;

import appeng.client.gui.DashPattern;
import appeng.client.guidebook.document.LytRect;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.util.Mth;

public final class DashedRectangle {
    private DashedRectangle() {
    }

    public static void render(PoseStack stack, LytRect bounds, DashPattern pattern, float z) {
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder builder = tesselator.m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        float t = 0.0f;
        if (pattern.animationCycleMs() > 0.0f) {
            t = (float)(System.currentTimeMillis() % (long)((int)pattern.animationCycleMs())) / pattern.animationCycleMs();
        }
        DashedRectangle.buildHorizontalDashedLine(builder, stack, t, bounds.x(), bounds.right(), bounds.y(), z, pattern, false);
        DashedRectangle.buildHorizontalDashedLine(builder, stack, t, bounds.x(), bounds.right(), (float)bounds.bottom() - pattern.width(), z, pattern, true);
        DashedRectangle.buildVerticalDashedLine(builder, stack, t, bounds.x(), bounds.y(), bounds.bottom(), z, pattern, true);
        DashedRectangle.buildVerticalDashedLine(builder, stack, t, (float)bounds.right() - pattern.width(), bounds.y(), bounds.bottom(), z, pattern, false);
        tesselator.m_85914_();
        RenderSystem.m_69461_();
        RenderSystem.m_69493_();
    }

    private static void buildHorizontalDashedLine(BufferBuilder builder, PoseStack stack, float t, float x1, float x2, float y, float z, DashPattern pattern, boolean reverse) {
        if (!reverse) {
            t = 1.0f - t;
        }
        float phase = t * pattern.length();
        Matrix4f pose = stack.m_85850_().m_85861_();
        int color = pattern.color();
        for (float x = x1 - phase; x < x2; x += pattern.length()) {
            builder.m_85982_(pose, Mth.m_14036_((float)(x + pattern.onLength()), (float)x1, (float)x2), y, z).m_193479_(color).m_5752_();
            builder.m_85982_(pose, Mth.m_14036_((float)x, (float)x1, (float)x2), y, z).m_193479_(color).m_5752_();
            builder.m_85982_(pose, Mth.m_14036_((float)x, (float)x1, (float)x2), y + pattern.width(), z).m_193479_(color).m_5752_();
            builder.m_85982_(pose, Mth.m_14036_((float)(x + pattern.onLength()), (float)x1, (float)x2), y + pattern.width(), z).m_193479_(color).m_5752_();
        }
    }

    private static void buildVerticalDashedLine(BufferBuilder builder, PoseStack stack, float t, float x, float y1, float y2, float z, DashPattern pattern, boolean reverse) {
        if (!reverse) {
            t = 1.0f - t;
        }
        float phase = t * pattern.length();
        Matrix4f pose = stack.m_85850_().m_85861_();
        int color = pattern.color();
        for (float y = y1 - phase; y < y2; y += pattern.length()) {
            builder.m_85982_(pose, x + pattern.width(), Mth.m_14036_((float)y, (float)y1, (float)y2), z).m_193479_(color).m_5752_();
            builder.m_85982_(pose, x, Mth.m_14036_((float)y, (float)y1, (float)y2), z).m_193479_(color).m_5752_();
            builder.m_85982_(pose, x, Mth.m_14036_((float)(y + pattern.onLength()), (float)y1, (float)y2), z).m_193479_(color).m_5752_();
            builder.m_85982_(pose, x + pattern.width(), Mth.m_14036_((float)(y + pattern.onLength()), (float)y1, (float)y2), z).m_193479_(color).m_5752_();
        }
    }
}

