/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.model;

import appeng.api.implementations.items.IBiometricCard;
import appeng.api.util.AEColor;
import appeng.client.render.cablebus.CubeBuilder;
import appeng.core.AELog;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;

class BiometricCardBakedModel
implements BakedModel {
    private final BakedModel baseModel;
    private final TextureAtlasSprite texture;
    private final int hash;
    private final Cache<Integer, BiometricCardBakedModel> modelCache;
    private final ImmutableList<BakedQuad> generalQuads;

    BiometricCardBakedModel(BakedModel baseModel, TextureAtlasSprite texture) {
        this(baseModel, texture, 0, BiometricCardBakedModel.createCache());
    }

    private BiometricCardBakedModel(BakedModel baseModel, TextureAtlasSprite texture, int hash, Cache<Integer, BiometricCardBakedModel> modelCache) {
        this.baseModel = baseModel;
        this.texture = texture;
        this.hash = hash;
        this.generalQuads = ImmutableList.copyOf(this.buildGeneralQuads());
        this.modelCache = modelCache;
    }

    private static Cache<Integer, BiometricCardBakedModel> createCache() {
        return CacheBuilder.newBuilder().maximumSize(100L).build();
    }

    public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction side, RandomSource rand) {
        List quads = this.baseModel.getQuads(state, side, rand, ModelData.EMPTY, null);
        if (side != null) {
            return quads;
        }
        ArrayList<BakedQuad> result = new ArrayList<BakedQuad>(quads.size() + this.generalQuads.size());
        result.addAll(quads);
        result.addAll((Collection<BakedQuad>)this.generalQuads);
        return result;
    }

    private List<BakedQuad> buildGeneralQuads() {
        CubeBuilder builder = new CubeBuilder();
        builder.setTexture(this.texture);
        AEColor col = AEColor.values()[Math.abs(3 + this.hash) % AEColor.values().length];
        if (this.hash == 0) {
            col = AEColor.BLACK;
        }
        for (int x = 0; x < 8; ++x) {
            for (int y = 0; y < 6; ++y) {
                boolean isLit;
                if (x == 0 || y == 0 || x == 7 || y == 5) {
                    isLit = false;
                } else {
                    boolean bl = isLit = (this.hash & 1 << x) != 0 || (this.hash & 1 << y) != 0;
                }
                if (isLit) {
                    builder.setColorRGB(col.mediumVariant);
                } else {
                    float scale = 0.0011764707f;
                    builder.setColorRGB((float)(col.blackVariant >> 16 & 0xFF) * 0.0011764707f, (float)(col.blackVariant >> 8 & 0xFF) * 0.0011764707f, (float)(col.blackVariant & 0xFF) * 0.0011764707f);
                }
                builder.addCube(4 + x, 6 + y, 7.5f, 4 + x + 1, 6 + y + 1, 8.5f);
            }
        }
        return builder.getOutput();
    }

    public boolean m_7541_() {
        return this.baseModel.m_7541_();
    }

    public boolean m_7539_() {
        return this.baseModel.m_7539_();
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return this.baseModel.m_7521_();
    }

    public TextureAtlasSprite m_6160_() {
        return this.baseModel.m_6160_();
    }

    public ItemTransforms m_7442_() {
        return this.baseModel.m_7442_();
    }

    public ItemOverrides m_7343_() {
        return new ItemOverrides(){

            public BakedModel m_173464_(BakedModel originalModel, ItemStack stack, ClientLevel level, LivingEntity entity, int seed) {
                int hash;
                IBiometricCard biometricCard;
                GameProfile gp;
                String username = "";
                Item item = stack.m_41720_();
                if (item instanceof IBiometricCard && (gp = (biometricCard = (IBiometricCard)item).getProfile(stack)) != null) {
                    username = gp.getId() != null ? gp.getId().toString() : gp.getName();
                }
                int n = hash = !username.isEmpty() ? username.hashCode() : 0;
                if (hash == 0) {
                    return BiometricCardBakedModel.this;
                }
                try {
                    return (BakedModel)BiometricCardBakedModel.this.modelCache.get((Object)hash, () -> new BiometricCardBakedModel(BiometricCardBakedModel.this.baseModel, BiometricCardBakedModel.this.texture, hash, BiometricCardBakedModel.this.modelCache));
                }
                catch (ExecutionException e) {
                    AELog.error(e);
                    return BiometricCardBakedModel.this;
                }
            }
        };
    }

    public BakedModel applyTransform(ItemTransforms.TransformType transformType, PoseStack poseStack, boolean applyLeftHandTransform) {
        this.baseModel.applyTransform(transformType, poseStack, applyLeftHandTransform);
        return this;
    }
}

