/*
 * Decompiled with CFR 0.152.
 */
package appeng.libs.mdast.model;

import appeng.libs.mdast.model.MdAstAnyContent;
import appeng.libs.mdast.model.MdAstNode;
import appeng.libs.unist.UnistParent;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class MdAstParent<T extends MdAstAnyContent>
extends MdAstNode
implements UnistParent {
    private final List<T> children = new ArrayList<T>();

    public MdAstParent(String type) {
        super(type);
    }

    public List<T> children() {
        return this.children;
    }

    protected abstract Class<T> childClass();

    public void addChild(MdAstNode node) {
        if (!this.childClass().isInstance(node)) {
            throw new IllegalArgumentException("Cannot add a node of type " + node.getClass() + " to " + this);
        }
        this.children.add((MdAstAnyContent)this.childClass().cast(node));
    }

    @Override
    protected void writeJson(JsonWriter writer) throws IOException {
        writer.name("children");
        writer.beginArray();
        for (MdAstAnyContent child : this.children) {
            ((MdAstNode)((Object)child)).toJson(writer);
        }
        writer.endArray();
    }

    @Override
    public void toText(StringBuilder buffer) {
        for (MdAstAnyContent child : this.children) {
            if (!(child instanceof MdAstNode)) continue;
            MdAstNode childNode = (MdAstNode)((Object)child);
            childNode.toText(buffer);
        }
    }

    public void replaceChild(MdAstNode child, MdAstNode replacement) {
        MdAstAnyContent replacementChild = (MdAstAnyContent)this.childClass().cast(replacement);
        for (int i = 0; i < this.children.size(); ++i) {
            if (this.children.get(i) != child) continue;
            this.children.set(i, replacementChild);
            return;
        }
        throw new IllegalStateException("Child " + child + " not found");
    }
}

