/*
 * Decompiled with CFR 0.152.
 */
package appeng.libs.micromark.extensions.gfm;

import appeng.libs.micromark.Assert;
import appeng.libs.micromark.CharUtil;
import appeng.libs.micromark.Construct;
import appeng.libs.micromark.ContentType;
import appeng.libs.micromark.Extension;
import appeng.libs.micromark.ListUtils;
import appeng.libs.micromark.State;
import appeng.libs.micromark.Token;
import appeng.libs.micromark.TokenProperty;
import appeng.libs.micromark.TokenizeContext;
import appeng.libs.micromark.Tokenizer;
import appeng.libs.micromark.extensions.gfm.Align;
import appeng.libs.micromark.factory.FactorySpace;
import java.util.ArrayList;
import java.util.List;

public class GfmTableSyntax
extends Extension {
    public static final TokenProperty<List<Align>> ALIGN = new TokenProperty();
    public static final Extension INSTANCE = new GfmTableSyntax();
    private final Construct nextPrefixedOrBlank;

    public GfmTableSyntax() {
        Construct construct = new Construct();
        construct.tokenize = this::tokenizeTable;
        construct.resolve = this::resolveTable;
        this.flow.put(Integer.MIN_VALUE, List.of(construct));
        this.nextPrefixedOrBlank = new Construct();
        this.nextPrefixedOrBlank.tokenize = this::tokenizeNextPrefixedOrBlank;
        this.nextPrefixedOrBlank.partial = true;
    }

    private List<Tokenizer.Event> resolveTable(List<Tokenizer.Event> events, TokenizeContext context) {
        int index = -1;
        boolean inHead = false;
        boolean inDelimiterRow = false;
        boolean inRow = false;
        int contentStart = -1;
        int contentEnd = -1;
        int cellStart = -1;
        boolean seenCellInRow = false;
        while (++index < events.size()) {
            Tokenizer.Event event = events.get(index);
            Token token = event.token();
            if (inRow) {
                if (token.type.equals("temporaryTableCellContent")) {
                    if (contentStart == -1) {
                        contentStart = index;
                    }
                    contentEnd = index;
                }
                if ((token.type.equals("tableCellDivider") || token.type.equals("tableRow")) && contentEnd != -1) {
                    Assert.check(contentStart != -1, "expected `contentStart` to be defined if `contentEnd` is");
                    Token content = new Token();
                    content.type = "tableContent";
                    content.start = events.get((int)contentStart).token().start;
                    content.end = events.get((int)contentEnd).token().end;
                    Token text = new Token();
                    text.type = "chunkText";
                    text.start = content.start;
                    text.end = content.end;
                    text.contentType = ContentType.TEXT;
                    Assert.check(contentStart != -1, "expected `contentStart` to be defined if `contentEnd` is");
                    ListUtils.splice(events, contentStart, contentEnd - contentStart + 1, List.of(Tokenizer.Event.enter(content, context), Tokenizer.Event.enter(text, context), Tokenizer.Event.exit(text, context), Tokenizer.Event.exit(content, context)));
                    index -= contentEnd - contentStart - 3;
                    contentStart = -1;
                    contentEnd = -1;
                }
            }
            if (events.get(index).isExit() && cellStart != -1 && cellStart + (seenCellInRow ? 0 : 1) < index && (token.type.equals("tableCellDivider") || token.type.equals("tableRow") && (cellStart + 3 < index || !events.get((int)cellStart).token().type.equals("whitespace")))) {
                Token cell = new Token();
                cell.type = inDelimiterRow ? "tableDelimiter" : (inHead ? "tableHeader" : "tableData");
                cell.start = events.get((int)cellStart).token().start;
                cell.end = events.get((int)index).token().end;
                ListUtils.splice(events, index + (token.type.equals("tableCellDivider") ? 1 : 0), 0, List.of(Tokenizer.Event.exit(cell, context)));
                ListUtils.splice(events, cellStart, 0, List.of(Tokenizer.Event.enter(cell, context)));
                cellStart = (index += 2) + 1;
                seenCellInRow = true;
            }
            if (token.type.equals("tableRow") && (inRow = events.get(index).isEnter())) {
                cellStart = index + 1;
                seenCellInRow = false;
            }
            if (token.type.equals("tableDelimiterRow") && (inDelimiterRow = events.get(index).isEnter())) {
                cellStart = index + 1;
                seenCellInRow = false;
            }
            if (!token.type.equals("tableHead")) continue;
            inHead = events.get(index).isEnter();
        }
        return events;
    }

    private State tokenizeTable(final TokenizeContext context, final Tokenizer.Effects effects, final State ok, final State nok) {
        class StateMachine {
            final List<Align> align = new ArrayList<Align>();
            int tableHeaderCount = 0;
            boolean seenDelimiter;
            boolean hasDash;

            StateMachine() {
            }

            State start(int code) {
                effects.enter("table").set(ALIGN, this.align);
                effects.enter("tableHead");
                effects.enter("tableRow");
                if (code == 124) {
                    return this.cellDividerHead(code);
                }
                ++this.tableHeaderCount;
                effects.enter("temporaryTableCellContent");
                Assert.check(!CharUtil.markdownLineEndingOrSpace(code), "expected non-space");
                return this.inCellContentHead(code);
            }

            State cellDividerHead(int code) {
                Assert.check(code == 124, "expected `|`");
                effects.enter("tableCellDivider");
                effects.consume(code);
                effects.exit("tableCellDivider");
                this.seenDelimiter = true;
                return this::cellBreakHead;
            }

            State cellBreakHead(int code) {
                if (code == Integer.MIN_VALUE || CharUtil.markdownLineEnding(code)) {
                    return this.atRowEndHead(code);
                }
                if (CharUtil.markdownSpace(code)) {
                    effects.enter("whitespace");
                    effects.consume(code);
                    return this::inWhitespaceHead;
                }
                if (this.seenDelimiter) {
                    this.seenDelimiter = false;
                    ++this.tableHeaderCount;
                }
                if (code == 124) {
                    return this.cellDividerHead(code);
                }
                effects.enter("temporaryTableCellContent");
                return this.inCellContentHead(code);
            }

            State inWhitespaceHead(int code) {
                if (CharUtil.markdownSpace(code)) {
                    effects.consume(code);
                    return this::inWhitespaceHead;
                }
                effects.exit("whitespace");
                return this.cellBreakHead(code);
            }

            State inCellContentHead(int code) {
                if (code == Integer.MIN_VALUE || code == 124 || CharUtil.markdownLineEndingOrSpace(code)) {
                    effects.exit("temporaryTableCellContent");
                    return this.cellBreakHead(code);
                }
                effects.consume(code);
                return code == 92 ? this::inCellContentEscapeHead : this::inCellContentHead;
            }

            State inCellContentEscapeHead(int code) {
                if (code == 92 || code == 124) {
                    effects.consume(code);
                    return this::inCellContentHead;
                }
                return this.inCellContentHead(code);
            }

            State atRowEndHead(int code) {
                if (code == Integer.MIN_VALUE) {
                    return nok.step(code);
                }
                Assert.check(CharUtil.markdownLineEnding(code), "expected eol");
                effects.exit("tableRow");
                effects.exit("tableHead");
                boolean originalInterrupt = context.isInterrupt();
                context.setInterrupt(true);
                Construct construct = new Construct();
                construct.tokenize = this::tokenizeRowEnd;
                construct.partial = true;
                return effects.attempt.hook(construct, c -> {
                    context.setInterrupt(originalInterrupt);
                    effects.enter("tableDelimiterRow");
                    return this.atDelimiterRowBreak(c);
                }, c -> {
                    context.setInterrupt(originalInterrupt);
                    return nok.step(c);
                }).step(code);
            }

            State atDelimiterRowBreak(int code) {
                if (code == Integer.MIN_VALUE || CharUtil.markdownLineEnding(code)) {
                    return this.rowEndDelimiter(code);
                }
                if (CharUtil.markdownSpace(code)) {
                    effects.enter("whitespace");
                    effects.consume(code);
                    return this::inWhitespaceDelimiter;
                }
                if (code == 45) {
                    effects.enter("tableDelimiterFiller");
                    effects.consume(code);
                    this.hasDash = true;
                    this.align.add(Align.NONE);
                    return this::inFillerDelimiter;
                }
                if (code == 58) {
                    effects.enter("tableDelimiterAlignment");
                    effects.consume(code);
                    effects.exit("tableDelimiterAlignment");
                    this.align.add(Align.LEFT);
                    return this::afterLeftAlignment;
                }
                if (code == 124) {
                    effects.enter("tableCellDivider");
                    effects.consume(code);
                    effects.exit("tableCellDivider");
                    return this::atDelimiterRowBreak;
                }
                return nok.step(code);
            }

            State inWhitespaceDelimiter(int code) {
                if (CharUtil.markdownSpace(code)) {
                    effects.consume(code);
                    return this::inWhitespaceDelimiter;
                }
                effects.exit("whitespace");
                return this.atDelimiterRowBreak(code);
            }

            State inFillerDelimiter(int code) {
                if (code == 45) {
                    effects.consume(code);
                    return this::inFillerDelimiter;
                }
                effects.exit("tableDelimiterFiller");
                if (code == 58) {
                    effects.enter("tableDelimiterAlignment");
                    effects.consume(code);
                    effects.exit("tableDelimiterAlignment");
                    this.align.set(this.align.size() - 1, this.align.get(this.align.size() - 1) == Align.LEFT ? Align.CENTER : Align.RIGHT);
                    return this::afterRightAlignment;
                }
                return this.atDelimiterRowBreak(code);
            }

            State afterLeftAlignment(int code) {
                if (code == 45) {
                    effects.enter("tableDelimiterFiller");
                    effects.consume(code);
                    this.hasDash = true;
                    return this::inFillerDelimiter;
                }
                return nok.step(code);
            }

            State afterRightAlignment(int code) {
                if (code == Integer.MIN_VALUE || CharUtil.markdownLineEnding(code)) {
                    return this.rowEndDelimiter(code);
                }
                if (CharUtil.markdownSpace(code)) {
                    effects.enter("whitespace");
                    effects.consume(code);
                    return this::inWhitespaceDelimiter;
                }
                if (code == 124) {
                    effects.enter("tableCellDivider");
                    effects.consume(code);
                    effects.exit("tableCellDivider");
                    return this::atDelimiterRowBreak;
                }
                return nok.step(code);
            }

            State rowEndDelimiter(int code) {
                effects.exit("tableDelimiterRow");
                if (!this.hasDash || this.tableHeaderCount != this.align.size()) {
                    return nok.step(code);
                }
                if (code == Integer.MIN_VALUE) {
                    return this.tableClose(code);
                }
                Assert.check(CharUtil.markdownLineEnding(code), "expected eol");
                Construct construct = new Construct();
                construct.tokenize = this::tokenizeRowEnd;
                construct.partial = true;
                return effects.check.hook(GfmTableSyntax.this.nextPrefixedOrBlank, this::tableClose, effects.attempt.hook(construct, FactorySpace.create(effects, this::bodyStart, "linePrefix", 4), this::tableClose)).step(code);
            }

            State tableClose(int code) {
                effects.exit("table");
                return ok.step(code);
            }

            State bodyStart(int code) {
                effects.enter("tableBody");
                return this.rowStartBody(code);
            }

            State rowStartBody(int code) {
                effects.enter("tableRow");
                if (code == 124) {
                    return this.cellDividerBody(code);
                }
                effects.enter("temporaryTableCellContent");
                return this.inCellContentBody(code);
            }

            State cellDividerBody(int code) {
                Assert.check(code == 124, "expected `|`");
                effects.enter("tableCellDivider");
                effects.consume(code);
                effects.exit("tableCellDivider");
                return this::cellBreakBody;
            }

            State cellBreakBody(int code) {
                if (code == Integer.MIN_VALUE || CharUtil.markdownLineEnding(code)) {
                    return this.atRowEndBody(code);
                }
                if (CharUtil.markdownSpace(code)) {
                    effects.enter("whitespace");
                    effects.consume(code);
                    return this::inWhitespaceBody;
                }
                if (code == 124) {
                    return this.cellDividerBody(code);
                }
                effects.enter("temporaryTableCellContent");
                return this.inCellContentBody(code);
            }

            State inWhitespaceBody(int code) {
                if (CharUtil.markdownSpace(code)) {
                    effects.consume(code);
                    return this::inWhitespaceBody;
                }
                effects.exit("whitespace");
                return this.cellBreakBody(code);
            }

            State inCellContentBody(int code) {
                if (code == Integer.MIN_VALUE || code == 124 || CharUtil.markdownLineEndingOrSpace(code)) {
                    effects.exit("temporaryTableCellContent");
                    return this.cellBreakBody(code);
                }
                effects.consume(code);
                return code == 92 ? this::inCellContentEscapeBody : this::inCellContentBody;
            }

            State inCellContentEscapeBody(int code) {
                if (code == 92 || code == 124) {
                    effects.consume(code);
                    return this::inCellContentBody;
                }
                return this.inCellContentBody(code);
            }

            State atRowEndBody(int code) {
                effects.exit("tableRow");
                if (code == Integer.MIN_VALUE) {
                    return this.tableBodyClose(code);
                }
                Construct construct = new Construct();
                construct.tokenize = this::tokenizeRowEnd;
                construct.partial = true;
                return effects.check.hook(GfmTableSyntax.this.nextPrefixedOrBlank, this::tableBodyClose, effects.attempt.hook(construct, FactorySpace.create(effects, this::rowStartBody, "linePrefix", 4), this::tableBodyClose)).step(code);
            }

            State tableBodyClose(int code) {
                effects.exit("tableBody");
                return this.tableClose(code);
            }

            State tokenizeRowEnd(final TokenizeContext context2, final Tokenizer.Effects effects2, final State ok2, final State nok2) {
                class RowEndStateMachine {
                    RowEndStateMachine() {
                    }

                    State start(int code) {
                        Assert.check(CharUtil.markdownLineEnding(code), "expected eol");
                        effects2.enter("lineEnding");
                        effects2.consume(code);
                        effects2.exit("lineEnding");
                        return FactorySpace.create(effects2, this::prefixed, "linePrefix");
                    }

                    State prefixed(int code) {
                        if (context2.isOnLazyLine() || code == Integer.MIN_VALUE || CharUtil.markdownLineEnding(code)) {
                            return nok2.step(code);
                        }
                        Tokenizer.Event tail = context2.getLastEvent();
                        if (!context2.getParser().constructs.nullDisable.contains("codeIndented") && tail != null && tail.token().type.equals("linePrefix") && tail.context().sliceSerialize(tail.token(), true).length() >= 4) {
                            return nok2.step(code);
                        }
                        context2.setGfmTableDynamicInterruptHack(true);
                        return effects2.check.hook(context2.getParser().constructs.flow, c -> {
                            context2.setGfmTableDynamicInterruptHack(false);
                            return nok2.step(c);
                        }, c -> {
                            context2.setGfmTableDynamicInterruptHack(false);
                            return ok2.step(c);
                        }).step(code);
                    }
                }
                return new RowEndStateMachine()::start;
            }
        }
        return new StateMachine()::start;
    }

    private State tokenizeNextPrefixedOrBlank(TokenizeContext context, final Tokenizer.Effects effects, final State ok, final State nok) {
        class StateMachine {
            int size;

            StateMachine() {
            }

            State start(int code) {
                effects.enter("check");
                effects.consume(code);
                return this::whitespace;
            }

            State whitespace(int code) {
                if (code == -1 || code == 32) {
                    effects.consume(code);
                    ++this.size;
                    return this.size == 4 ? ok : this::whitespace;
                }
                if (code == Integer.MIN_VALUE || CharUtil.markdownLineEndingOrSpace(code)) {
                    return ok.step(code);
                }
                return nok.step(code);
            }
        }
        return new StateMachine()::start;
    }
}

