/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu.me.crafting;

import appeng.api.config.SecurityPermissions;
import appeng.api.networking.crafting.CalculationStrategy;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.ITerminalHost;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.ConfirmAutoCraftPacket;
import appeng.menu.AEBaseMenu;
import appeng.menu.ISubMenu;
import appeng.menu.MenuOpener;
import appeng.menu.SlotSemantics;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.menu.locator.MenuLocator;
import appeng.menu.me.crafting.CraftConfirmMenu;
import appeng.menu.slot.AppEngSlot;
import appeng.menu.slot.InaccessibleSlot;
import appeng.util.inv.AppEngInternalInventory;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.Level;

public class CraftAmountMenu
extends AEBaseMenu
implements ISubMenu {
    public static final MenuType<CraftAmountMenu> TYPE = MenuTypeBuilder.create(CraftAmountMenu::new, ITerminalHost.class).requirePermission(SecurityPermissions.CRAFT).build("craftamount");
    private final AppEngSlot craftingItem;
    private AEKey whatToCraft;
    private final ITerminalHost host;

    public CraftAmountMenu(int id, Inventory ip, ITerminalHost host) {
        super(TYPE, id, ip, host);
        this.host = host;
        this.craftingItem = new InaccessibleSlot(new AppEngInternalInventory(1), 0);
        this.craftingItem.setHideAmount(true);
        this.addSlot(this.craftingItem, SlotSemantics.MACHINE_OUTPUT);
    }

    @Override
    public ITerminalHost getHost() {
        return this.host;
    }

    public static void open(ServerPlayer player, MenuLocator locator, AEKey whatToCraft, int initialAmount) {
        MenuOpener.open(TYPE, (Player)player, locator);
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof CraftAmountMenu) {
            CraftAmountMenu cca = (CraftAmountMenu)abstractContainerMenu;
            cca.setWhatToCraft(whatToCraft, initialAmount);
            cca.m_38946_();
        }
    }

    @Override
    public void m_38946_() {
        super.m_38946_();
        this.verifyPermissions(SecurityPermissions.CRAFT, false);
    }

    public Level getLevel() {
        return this.getPlayerInventory().f_35978_.f_19853_;
    }

    private void setWhatToCraft(AEKey whatToCraft, int initialAmount) {
        this.whatToCraft = Objects.requireNonNull(whatToCraft, "whatToCraft");
        this.craftingItem.m_5852_(GenericStack.wrapInItemStack(whatToCraft, initialAmount));
    }

    public void confirm(int amount, boolean autoStart) {
        if (!this.isServerSide()) {
            NetworkHandler.instance().sendToServer(new ConfirmAutoCraftPacket(amount, autoStart));
            return;
        }
        if (this.whatToCraft == null) {
            return;
        }
        MenuLocator locator = this.getLocator();
        if (locator != null) {
            Player player = this.getPlayerInventory().f_35978_;
            MenuOpener.open(CraftConfirmMenu.TYPE, player, locator);
            AbstractContainerMenu abstractContainerMenu = player.f_36096_;
            if (abstractContainerMenu instanceof CraftConfirmMenu) {
                CraftConfirmMenu ccc = (CraftConfirmMenu)abstractContainerMenu;
                ccc.setAutoStart(autoStart);
                ccc.planJob(this.whatToCraft, amount, CalculationStrategy.REPORT_MISSING_ITEMS);
                this.m_38946_();
            }
        }
    }

    @Nullable
    public GenericStack getWhatToCraft() {
        return GenericStack.unwrapItemStack(this.craftingItem.m_7993_());
    }
}

