/*
 * Decompiled with CFR 0.152.
 */
package appeng.shaded.methvin.watcher.hashing;

import appeng.shaded.methvin.watcher.hashing.ByteArrayFileHash;
import java.nio.ByteBuffer;
import java.util.Arrays;

public interface FileHash {
    public static final FileHash DIRECTORY = new FileHash(){
        private byte[] emptyBytes = new byte[0];

        public String toString() {
            return "DIRECTORY";
        }

        @Override
        public byte[] asBytes() {
            return this.emptyBytes;
        }
    };

    public static FileHash fromBytes(byte[] byArray) {
        return new ByteArrayFileHash(Arrays.copyOf(byArray, byArray.length));
    }

    public static FileHash fromLong(long l) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        byteBuffer.putLong(l);
        return new ByteArrayFileHash(byteBuffer.array());
    }

    public static FileHash directory() {
        return DIRECTORY;
    }

    default public String asString() {
        return this.toString();
    }

    public byte[] asBytes();
}

