/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.inv;

import appeng.api.inventories.BaseInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import appeng.util.inv.filter.IAEItemFilter;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;

public class AppEngInternalInventory
extends BaseInternalInventory {
    private boolean enableClientEvents = false;
    private InternalInventoryHost host;
    private final NonNullList<ItemStack> stacks;
    private final int[] maxStack;
    private IAEItemFilter filter;
    private boolean notifyingChanges = false;

    public AppEngInternalInventory(InternalInventoryHost host, int size, int maxStack, IAEItemFilter filter) {
        this.setHost(host);
        this.setFilter(filter);
        this.maxStack = new int[size];
        this.stacks = NonNullList.m_122780_((int)size, (Object)ItemStack.f_41583_);
        Arrays.fill(this.maxStack, maxStack);
    }

    public AppEngInternalInventory(@Nullable InternalInventoryHost inventory, int size, int maxStack) {
        this(inventory, size, maxStack, null);
    }

    public AppEngInternalInventory(int size) {
        this(null, size, 64);
    }

    public AppEngInternalInventory(@Nullable InternalInventoryHost inventory, int size) {
        this(inventory, size, 64);
    }

    public void setFilter(IAEItemFilter filter) {
        this.filter = filter;
    }

    @Override
    public int getSlotLimit(int slot) {
        return this.maxStack[slot];
    }

    @Override
    public ItemStack getStackInSlot(int slotIndex) {
        return (ItemStack)this.stacks.get(slotIndex);
    }

    @Override
    public void setItemDirect(int slot, ItemStack stack) {
        this.stacks.set(slot, (Object)stack);
        this.notifyContentsChanged(slot);
    }

    private void notifyContentsChanged(int slot) {
        this.onContentsChanged(slot);
    }

    @Override
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        Preconditions.checkArgument((slot >= 0 && slot < this.size() ? 1 : 0) != 0, (Object)"slot out of range");
        if (this.filter != null && !this.filter.allowExtract(this, slot, amount)) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = (ItemStack)this.stacks.get(slot);
        int toExtract = Math.min(stack.m_41613_(), Math.min(amount, stack.m_41741_()));
        if (toExtract <= 0) {
            return ItemStack.f_41583_;
        }
        if (stack.m_41613_() <= toExtract) {
            if (!simulate) {
                this.setItemDirect(slot, ItemStack.f_41583_);
                this.notifyContentsChanged(slot);
                return stack;
            }
            return stack.m_41777_();
        }
        ItemStack result = stack.m_41777_();
        if (!simulate) {
            stack.m_41774_(toExtract);
            this.notifyContentsChanged(slot);
        }
        result.m_41764_(toExtract);
        return result;
    }

    protected void onContentsChanged(int slot) {
        if (this.host != null && this.eventsEnabled() && !this.notifyingChanges) {
            this.notifyingChanges = true;
            this.host.onChangeInventory(this, slot);
            this.host.saveChanges();
            this.notifyingChanges = false;
        }
    }

    protected boolean eventsEnabled() {
        return this.host != null && !this.host.isClientSide() || this.isEnableClientEvents();
    }

    public void setMaxStackSize(int slot, int size) {
        this.maxStack[slot] = size;
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        if (this.maxStack[slot] == 0) {
            return false;
        }
        if (this.filter != null) {
            return this.filter.allowInsert(this, slot, stack);
        }
        return true;
    }

    public void writeToNBT(CompoundTag data, String name) {
        if (this.isEmpty()) {
            data.m_128473_(name);
            return;
        }
        ListTag items = new ListTag();
        for (int i = 0; i < this.stacks.size(); ++i) {
            ItemStack stack = (ItemStack)this.stacks.get(i);
            if (stack.m_41619_()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.m_128405_("Slot", i);
            items.add((Object)stack.m_41739_(itemTag));
        }
        data.m_128365_(name, (Tag)items);
    }

    public void readFromNBT(CompoundTag data, String name) {
        if (data.m_128425_(name, 9)) {
            ListTag tagList = data.m_128437_(name, 10);
            for (Tag itemTag : tagList) {
                CompoundTag itemCompound = (CompoundTag)itemTag;
                int slot = itemCompound.m_128451_("Slot");
                if (slot < 0 || slot >= this.stacks.size()) continue;
                this.stacks.set(slot, (Object)ItemStack.m_41712_((CompoundTag)itemCompound));
            }
        }
    }

    private boolean isEnableClientEvents() {
        return this.enableClientEvents;
    }

    public void setEnableClientEvents(boolean enableClientEvents) {
        this.enableClientEvents = enableClientEvents;
    }

    @ApiStatus.Internal
    public InternalInventoryHost getHost() {
        return this.host;
    }

    protected final void setHost(InternalInventoryHost host) {
        this.host = host;
    }

    @Override
    public int size() {
        return this.stacks.size();
    }
}

