/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.teleporter.blocks;

import javax.annotation.Nonnull;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.NBTTools;
import mcjty.rftoolsutility.RFToolsUtility;
import mcjty.rftoolsutility.modules.teleporter.blocks.MatterReceiverTileEntity;
import mcjty.rftoolsutility.modules.teleporter.blocks.MatterTransmitterTileEntity;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestination;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestinations;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class SimpleDialerItemBlock
extends BlockItem {
    public SimpleDialerItemBlock(Block block) {
        super(block, RFToolsUtility.setup.defaultProperties());
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext context) {
        ItemStack stack = context.m_43722_();
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        BlockEntity te = world.m_7702_(pos);
        if (!world.f_46443_) {
            if (te instanceof MatterTransmitterTileEntity) {
                MatterTransmitterTileEntity transmitter = (MatterTransmitterTileEntity)te;
                if (!transmitter.checkAccess(player.m_5446_().getString())) {
                    Logging.message((Player)player, (String)(ChatFormatting.RED + "You have no access to this matter transmitter!"));
                    return InteractionResult.FAIL;
                }
                BlockPos mpos = transmitter.m_58899_();
                NBTTools.setInfoNBT((ItemStack)stack, CompoundTag::m_128405_, (String)"transX", (Object)mpos.m_123341_());
                NBTTools.setInfoNBT((ItemStack)stack, CompoundTag::m_128405_, (String)"transY", (Object)mpos.m_123342_());
                NBTTools.setInfoNBT((ItemStack)stack, CompoundTag::m_128405_, (String)"transZ", (Object)mpos.m_123343_());
                NBTTools.setInfoNBT((ItemStack)stack, CompoundTag::m_128359_, (String)"transDim", (Object)world.m_46472_().m_135782_().toString());
                if (transmitter.isDialed()) {
                    Integer id = transmitter.getTeleportId();
                    boolean access = this.checkReceiverAccess(player, world, id);
                    if (!access) {
                        Logging.message((Player)player, (String)(ChatFormatting.RED + "You have no access to the matter receiver!"));
                        return InteractionResult.FAIL;
                    }
                    NBTTools.setInfoNBT((ItemStack)stack, CompoundTag::m_128405_, (String)"receiver", (Object)id);
                    Logging.message((Player)player, (String)(ChatFormatting.YELLOW + "Receiver set!"));
                }
                Logging.message((Player)player, (String)(ChatFormatting.YELLOW + "Transmitter set!"));
            } else if (te instanceof MatterReceiverTileEntity) {
                MatterReceiverTileEntity receiver = (MatterReceiverTileEntity)te;
                Integer id = receiver.getOrCalculateID();
                boolean access = this.checkReceiverAccess(player, world, id);
                if (!access) {
                    Logging.message((Player)player, (String)(ChatFormatting.RED + "You have no access to this matter receiver!"));
                    return InteractionResult.FAIL;
                }
                NBTTools.setInfoNBT((ItemStack)stack, CompoundTag::m_128405_, (String)"receiver", (Object)id);
                Logging.message((Player)player, (String)(ChatFormatting.YELLOW + "Receiver set!"));
            } else {
                return super.m_6225_(context);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6225_(context);
    }

    private boolean checkReceiverAccess(Player player, Level world, Integer id) {
        MatterReceiverTileEntity receiver;
        BlockEntity recTe;
        ServerLevel worldForDimension;
        TeleportDestination destination;
        boolean access = true;
        TeleportDestinations destinations = TeleportDestinations.get(world);
        GlobalPos coordinate = destinations.getCoordinateForId(id);
        if (coordinate != null && (destination = destinations.getDestination(coordinate)) != null && (worldForDimension = LevelTools.getLevel(destination.getDimension())) != null && (recTe = worldForDimension.m_7702_(destination.getCoordinate())) instanceof MatterReceiverTileEntity && !(destination = (receiver = (MatterReceiverTileEntity)recTe).updateDestination()).checkAccess(world, player.m_20148_())) {
            access = false;
        }
        return access;
    }
}

