/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class MessageFlagSync {
    public boolean wither;
    public boolean dragon;

    public MessageFlagSync(boolean witherIn, boolean dragonIn) {
        this.wither = witherIn;
        this.dragon = dragonIn;
    }

    public static void encode(MessageFlagSync message, FriendlyByteBuf buf) {
        buf.writeBoolean(message.wither);
        buf.writeBoolean(message.dragon);
    }

    public static MessageFlagSync decode(FriendlyByteBuf buf) {
        return new MessageFlagSync(buf.readBoolean(), buf.readBoolean());
    }

    public static void handle(MessageFlagSync message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide().isClient()) {
            ctx.get().enqueueWork(() -> {
                CompoundTag nbt = Minecraft.m_91087_().f_91074_.getPersistentData();
                nbt.m_128379_("MGU_WitherMuffle", message.wither);
                nbt.m_128379_("MGU_DragonMuffle", message.dragon);
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

