/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.pillar;

import com.mojang.math.Vector4f;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.util.Utils;

public class FramedWallModel
extends FramedBlockModel {
    private static final Vector4f[] rects = new Vector4f[]{new Vector4f(0.3125f, 0.0f, 0.6875f, 0.3125f), new Vector4f(0.3125f, 0.6875f, 0.6875f, 1.0f), new Vector4f(0.0f, 0.3125f, 0.3125f, 0.6875f), new Vector4f(0.6875f, 0.3125f, 1.0f, 0.6875f), new Vector4f(0.3125f, 0.0f, 0.6875f, 0.25f), new Vector4f(0.3125f, 0.75f, 0.6875f, 1.0f), new Vector4f(0.0f, 0.3125f, 0.25f, 0.6875f), new Vector4f(0.75f, 0.3125f, 1.0f, 0.6875f)};
    private static final float LOW_HEIGHT = 0.875f;
    private static final float SMALL_MIN = 0.3125f;
    private static final float SMALL_MAX = 0.6875f;
    private static final float LARGE_MIN = 0.25f;
    private static final float LARGE_MAX = 0.75f;
    private final boolean center;
    private final WallSide north;
    private final WallSide east;
    private final WallSide south;
    private final WallSide west;

    public FramedWallModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.center = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61366_);
        this.north = (WallSide)state.m_61143_((Property)BlockStateProperties.f_61379_);
        this.east = (WallSide)state.m_61143_((Property)BlockStateProperties.f_61378_);
        this.south = (WallSide)state.m_61143_((Property)BlockStateProperties.f_61380_);
        this.west = (WallSide)state.m_61143_((Property)BlockStateProperties.f_61381_);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        if (this.north != WallSide.NONE) {
            this.buildWallHalfSegment(quadMap, quad, Direction.NORTH, this.north);
        }
        if (this.south != WallSide.NONE) {
            this.buildWallHalfSegment(quadMap, quad, Direction.SOUTH, this.south);
        }
        if (this.east != WallSide.NONE) {
            this.buildWallHalfSegment(quadMap, quad, Direction.EAST, this.east);
        }
        if (this.west != WallSide.NONE) {
            this.buildWallHalfSegment(quadMap, quad, Direction.WEST, this.west);
        }
        FramedWallModel.buildWallEndCap(quadMap, quad, Direction.NORTH, this.north);
        FramedWallModel.buildWallEndCap(quadMap, quad, Direction.EAST, this.east);
        FramedWallModel.buildWallEndCap(quadMap, quad, Direction.SOUTH, this.south);
        FramedWallModel.buildWallEndCap(quadMap, quad, Direction.WEST, this.west);
        this.buildCenterPillar(quadMap, quad);
    }

    private void buildWallHalfSegment(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad, Direction dir, WallSide height) {
        if (height != WallSide.NONE) {
            Direction quadDir = quad.m_111306_();
            if (Utils.isY(quadDir)) {
                Vector4f rect = rects[dir.ordinal() - 2 + (this.center ? 4 : 0)];
                boolean inset = height != WallSide.TALL && quadDir != Direction.DOWN;
                QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(rect.m_123601_(), rect.m_123615_(), rect.m_123616_(), rect.m_123617_())).applyIf(Modifiers.setPosition(0.875f), inset).export(quadMap.get(inset ? null : quadDir));
            } else if (quadDir.m_122434_() != dir.m_122434_()) {
                QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(dir.m_122424_(), this.center ? 0.25f : 0.3125f)).applyIf(Modifiers.cutSideUpDown(false, 0.875f), height != WallSide.TALL).apply(Modifiers.setPosition(0.6875f)).export(quadMap.get(null));
            }
        }
    }

    private static void buildWallEndCap(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad, Direction dir, WallSide height) {
        if (quad.m_111306_() == dir && height != WallSide.NONE) {
            QuadModifier.geometry(quad).apply(Modifiers.cutSide(0.3125f, 0.0f, 0.6875f, height == WallSide.TALL ? 1.0f : 0.875f)).export(quadMap.get(dir));
        }
    }

    private void buildCenterPillar(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        Direction quadDir = quad.m_111306_();
        if (this.center) {
            if (Utils.isY(quadDir)) {
                QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(0.25f, 0.25f, 0.75f, 0.75f)).export(quadMap.get(quadDir));
            } else {
                QuadModifier.geometry(quad).apply(Modifiers.cutSide(0.25f, 0.0f, 0.75f, 1.0f)).apply(Modifiers.setPosition(0.75f)).export(quadMap.get(null));
            }
        } else {
            boolean tall = this.north == WallSide.TALL || this.east == WallSide.TALL || this.south == WallSide.TALL || this.west == WallSide.TALL;
            switch (quadDir) {
                case UP: 
                case DOWN: {
                    boolean inset = !tall && quadDir == Direction.UP;
                    QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(0.3125f, 0.3125f, 0.6875f, 0.6875f)).applyIf(Modifiers.setPosition(0.875f), inset).export(quadMap.get(inset ? null : quadDir));
                    break;
                }
                case NORTH: {
                    FramedWallModel.buildSmallCenterSide(quadMap.get(null), quad, this.north, tall);
                    break;
                }
                case EAST: {
                    FramedWallModel.buildSmallCenterSide(quadMap.get(null), quad, this.east, tall);
                    break;
                }
                case SOUTH: {
                    FramedWallModel.buildSmallCenterSide(quadMap.get(null), quad, this.south, tall);
                    break;
                }
                case WEST: {
                    FramedWallModel.buildSmallCenterSide(quadMap.get(null), quad, this.west, tall);
                }
            }
        }
    }

    private static void buildSmallCenterSide(List<BakedQuad> quadList, BakedQuad quad, WallSide height, boolean tall) {
        if (height == WallSide.NONE) {
            QuadModifier.geometry(quad).apply(Modifiers.cutSide(0.3125f, 0.0f, 0.6875f, tall ? 1.0f : 0.875f)).apply(Modifiers.setPosition(0.6875f)).export(quadList);
        } else if (tall && height == WallSide.LOW) {
            QuadModifier.geometry(quad).apply(Modifiers.cutSide(0.3125f, 0.875f, 0.6875f, 1.0f)).apply(Modifiers.setPosition(0.6875f)).export(quadList);
        }
    }
}

