/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import xfacthd.framedblocks.api.data.CamoContainer;
import xfacthd.framedblocks.api.data.EmptyCamoContainer;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.blockentity.FramedDoubleBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.util.DoubleSoundMode;

public class FramedStackedSlopeSlabBlockEntity
extends FramedDoubleBlockEntity {
    private final boolean corner;
    private final boolean innerCorner;

    public FramedStackedSlopeSlabBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FBContent.blockEntityTypeFramedStackedSlopeSlab.get(), pos, state);
        BlockType type = (BlockType)this.getBlockType();
        this.corner = type != BlockType.FRAMED_FLAT_STACKED_SLOPE_SLAB_CORNER;
        this.innerCorner = type == BlockType.FRAMED_FLAT_STACKED_INNER_SLOPE_SLAB_CORNER;
    }

    @Override
    protected boolean hitSecondary(BlockHitResult hit) {
        boolean top = (Boolean)this.m_58900_().m_61143_((Property)FramedProperties.TOP);
        if (hit.m_82434_() == Direction.DOWN) {
            return top;
        }
        boolean upper = hit.m_82434_() == Direction.UP || Mth.m_14185_((double)hit.m_82450_().m_7098_()) >= 0.5;
        return upper != top;
    }

    @Override
    public DoubleSoundMode getSoundMode() {
        boolean top = (Boolean)this.m_58900_().m_61143_((Property)FramedProperties.TOP);
        return top ? DoubleSoundMode.FIRST : DoubleSoundMode.SECOND;
    }

    @Override
    public CamoContainer getCamo(Direction side) {
        boolean top = (Boolean)this.m_58900_().m_61143_((Property)FramedProperties.TOP);
        if (side == Direction.UP) {
            return top ? this.getCamo() : this.getCamoTwo();
        }
        if (side == Direction.DOWN) {
            return top ? this.getCamoTwo() : this.getCamo();
        }
        return EmptyCamoContainer.EMPTY;
    }

    @Override
    public boolean isSolidSide(Direction side) {
        boolean top = (Boolean)this.m_58900_().m_61143_((Property)FramedProperties.TOP);
        if (!top && side == Direction.DOWN || top && side == Direction.UP) {
            return this.getCamo(side).isSolid((BlockGetter)this.f_58857_, this.f_58858_);
        }
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)FramedProperties.FACING_HOR);
        if (side == facing && !this.corner || side == facing.m_122428_() && this.innerCorner) {
            return this.getCamo().isSolid((BlockGetter)this.f_58857_, this.f_58858_) && this.getCamoTwo().isSolid((BlockGetter)this.f_58857_, this.f_58858_);
        }
        return false;
    }
}

