/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.compat.jei;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.api.runtime.IRecipesGui;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLEnvironment;

public final class JeiCompat {
    private static boolean loadedClient = false;

    public static void init() {
        if (FMLEnvironment.dist.isClient() && ModList.get().isLoaded("jei")) {
            loadedClient = true;
        }
    }

    public static boolean isShowRecipePressed(InputConstants.Key key) {
        if (loadedClient) {
            return Guarded.isShowRecipePressed(key);
        }
        return false;
    }

    public static boolean handleShowRecipeRequest(ItemStack result) {
        if (loadedClient) {
            return Guarded.handleButtonRecipeRequest(result);
        }
        return false;
    }

    static final class Guarded {
        private static IJeiRuntime runtime = null;

        Guarded() {
        }

        public static boolean isShowRecipePressed(InputConstants.Key key) {
            Preconditions.checkNotNull((Object)runtime, (Object)"Runtime not set");
            return runtime.getKeyMappings().getShowRecipe().isActiveAndMatches(key);
        }

        private static boolean handleButtonRecipeRequest(ItemStack result) {
            Preconditions.checkNotNull((Object)runtime, (Object)"Runtime not set");
            IRecipesGui gui = runtime.getRecipesGui();
            IJeiHelpers helpers = runtime.getJeiHelpers();
            IIngredientManager ingredients = helpers.getIngredientManager();
            IFocusFactory focusFactory = helpers.getFocusFactory();
            Optional ingredient = ingredients.createTypedIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)result);
            if (ingredient.isPresent()) {
                IFocus focus = focusFactory.createFocus(RecipeIngredientRole.OUTPUT, (ITypedIngredient)ingredient.get());
                gui.show(focus);
                return true;
            }
            return false;
        }

        public static void acceptRuntime(IJeiRuntime runtime) {
            Guarded.runtime = runtime;
        }
    }
}

