/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.blueprint;

import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedBlockEntity;
import xfacthd.framedblocks.api.blueprint.BlueprintCopyBehaviour;
import xfacthd.framedblocks.api.data.CamoContainer;

public final class DoorCopyBehaviour
implements BlueprintCopyBehaviour {
    private static final String SECOND_CAMO_KEY = "camo_data_two";

    @Override
    public boolean writeToBlueprint(Level level, BlockPos pos, BlockState state, FramedBlockEntity be, CompoundTag blueprintData) {
        CompoundTag compoundTag;
        boolean top = state.m_61143_((Property)BlockStateProperties.f_61401_) == DoubleBlockHalf.UPPER;
        BlockPos posTwo = top ? pos.m_7495_() : pos.m_7494_();
        CompoundTag nbtOne = be.writeToBlueprint();
        BlockEntity blockEntity = level.m_7702_(posTwo);
        if (blockEntity instanceof FramedBlockEntity) {
            FramedBlockEntity beTwo = (FramedBlockEntity)blockEntity;
            compoundTag = beTwo.writeToBlueprint();
        } else {
            compoundTag = new CompoundTag();
        }
        CompoundTag nbtTwo = compoundTag;
        blueprintData.m_128365_("camo_data", (Tag)(top ? nbtTwo : nbtOne));
        blueprintData.m_128365_(SECOND_CAMO_KEY, (Tag)(top ? nbtOne : nbtTwo));
        return true;
    }

    @Override
    public Optional<Set<CamoContainer>> getCamos(CompoundTag blueprintData) {
        ObjectArraySet camos = new ObjectArraySet(2);
        camos.add(CamoContainer.load(blueprintData.m_128469_("camo_data").m_128469_("camo")));
        camos.add(CamoContainer.load(blueprintData.m_128469_(SECOND_CAMO_KEY).m_128469_("camo")));
        return Optional.of(camos);
    }

    @Override
    public int getGlowstoneCount(CompoundTag blueprintData) {
        int count = BlueprintCopyBehaviour.super.getGlowstoneCount(blueprintData);
        if (blueprintData.m_128469_(SECOND_CAMO_KEY).m_128471_("glowing")) {
            ++count;
        }
        return count;
    }

    @Override
    public int getIntangibleCount(CompoundTag blueprintData) {
        return 0;
    }

    @Override
    public void postProcessPaste(Level level, BlockPos pos, Player player, CompoundTag blueprintData, ItemStack dummyStack) {
        if (!blueprintData.m_128425_(SECOND_CAMO_KEY, 10)) {
            return;
        }
        BlockPos topPos = pos.m_7494_();
        if (level.m_7702_(topPos) instanceof FramedBlockEntity) {
            dummyStack.m_41784_().m_128365_("BlockEntityTag", blueprintData.m_128423_(SECOND_CAMO_KEY));
            BlockItem.m_40582_((Level)level, (Player)player, (BlockPos)topPos, (ItemStack)dummyStack);
        }
    }
}

