/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xfacthd.framedblocks.common.blockentity.FramedItemFrameBlockEntity;

@Mixin(value={MapItemSavedData.class})
public abstract class MixinMapItemSavedData
implements FramedItemFrameBlockEntity.MapMarkerRemover {
    @Unique
    private final Map<String, FramedItemFrameBlockEntity.FramedMap> framedblocks$frameMarkers = new HashMap<String, FramedItemFrameBlockEntity.FramedMap>();
    @Shadow
    @Final
    private boolean f_77888_;

    @Shadow
    protected abstract void m_77937_(MapDecoration.Type var1, @Nullable LevelAccessor var2, String var3, double var4, double var6, double var8, @Nullable Component var10);

    @Shadow
    protected abstract void m_164799_(String var1);

    @ModifyExpressionValue(method={"tickCarriedBy"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;isFramed()Z", ordinal=0)})
    private boolean framedblocks$checkVanillaFramedOrCustomFramed(boolean isFramed, Player player, ItemStack stack) {
        return isFramed || stack.m_41782_() && stack.m_41783_().m_128441_("framedblocks:framed");
    }

    @ModifyExpressionValue(method={"tickCarriedBy"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;isFramed()Z", ordinal=1)})
    private boolean framedblocks$checkNotVanillaFramedAndNotCustomFramed(boolean isFramed, Player player, ItemStack stack) {
        return isFramed || stack.m_41782_() && stack.m_41783_().m_128441_("framedblocks:framed");
    }

    @Inject(method={"tickCarriedBy"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;getTag()Lnet/minecraft/nbt/CompoundTag;")})
    private void framedblocks$updateFramedItemFrameMarker(Player player, ItemStack mapStack, CallbackInfo ci) {
        BlockPos pos;
        String frameId;
        CompoundTag tag;
        if (this.f_77888_ && mapStack.m_41782_() && (tag = mapStack.m_41783_().m_128469_("framedblocks:framed")) != null && !this.framedblocks$frameMarkers.containsKey(frameId = FramedItemFrameBlockEntity.FramedMap.makeFrameId(pos = BlockPos.m_122022_((long)tag.m_128454_("pos"))))) {
            int rot = tag.m_128445_("y_rot") * 90;
            FramedItemFrameBlockEntity.FramedMap framedMap = new FramedItemFrameBlockEntity.FramedMap(pos, rot);
            this.framedblocks$addMapMarker((LevelAccessor)player.f_19853_, frameId, framedMap);
        }
    }

    @Inject(method={"load"}, at={@At(value="TAIL")})
    private static void framedblocks$loadCustomMapMarkers(CompoundTag tag, CallbackInfoReturnable<MapItemSavedData> cir) {
        ListTag frames = tag.m_128437_("framedblocks:frames", 10);
        for (int i = 0; i < frames.size(); ++i) {
            CompoundTag frameTag = frames.m_128728_(i);
            FramedItemFrameBlockEntity.FramedMap map = FramedItemFrameBlockEntity.FramedMap.load(frameTag);
            String frameId = FramedItemFrameBlockEntity.FramedMap.makeFrameId(map.pos());
            ((MixinMapItemSavedData)cir.getReturnValue()).framedblocks$addMapMarker(null, frameId, map);
        }
    }

    @Inject(method={"save"}, at={@At(value="TAIL")})
    private void framedblocks$saveCustomMapMarkers(CompoundTag tag, CallbackInfoReturnable<CompoundTag> cir) {
        if (!this.framedblocks$frameMarkers.isEmpty()) {
            ListTag frames = new ListTag();
            this.framedblocks$frameMarkers.forEach((id, marker) -> frames.add((Object)marker.save()));
            tag.m_128365_("framedblocks:frames", (Tag)frames);
        }
    }

    @Override
    public void framedblocks$removeMapMarker(BlockPos pos) {
        String frameId = FramedItemFrameBlockEntity.FramedMap.makeFrameId(pos);
        this.m_164799_(frameId);
        this.framedblocks$frameMarkers.remove(frameId);
    }

    @Unique
    private void framedblocks$addMapMarker(LevelAccessor level, String frameId, FramedItemFrameBlockEntity.FramedMap framedMap) {
        BlockPos pos = framedMap.pos();
        int rot = framedMap.yRot();
        this.m_77937_(MapDecoration.Type.FRAME, level, frameId, pos.m_123341_(), pos.m_123343_(), rot, null);
        this.framedblocks$frameMarkers.put(frameId, framedMap);
    }
}

