/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block;

import java.util.Random;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.container.ContainerUtils;
import net.blay09.mods.cookingforblockheads.ItemUtils;
import net.blay09.mods.cookingforblockheads.block.BlockKitchen;
import net.blay09.mods.cookingforblockheads.item.ModItems;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.blay09.mods.cookingforblockheads.tile.ModBlockEntities;
import net.blay09.mods.cookingforblockheads.tile.OvenBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class OvenBlock
extends BlockKitchen {
    public static BooleanProperty POWERED = BooleanProperty.m_61465_((String)"powered");
    public static BooleanProperty ACTIVE = BooleanProperty.m_61465_((String)"active");
    public static final String name = "oven";
    public static final ResourceLocation registryName = new ResourceLocation("cookingforblockheads", "oven");
    private static final Random random = new Random();

    public OvenBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60918_(SoundType.f_56743_).m_60913_(5.0f, 10.0f), registryName);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, POWERED, ACTIVE});
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        ItemStack heldItem = player.m_21120_(hand);
        if (heldItem.m_41720_() == ModItems.heatingUnit) {
            return InteractionResult.PASS;
        }
        if (rayTraceResult.m_82434_() == Direction.UP && CookingRegistry.isToolItem(heldItem)) {
            OvenBlockEntity tileOven;
            Direction stateFacing = (Direction)state.m_61143_((Property)FACING);
            double hx = rayTraceResult.m_82450_().f_82479_;
            double hz = rayTraceResult.m_82450_().f_82481_;
            switch (stateFacing) {
                case NORTH: {
                    hx = 1.0 - rayTraceResult.m_82450_().f_82479_;
                    hz = 1.0 - rayTraceResult.m_82450_().f_82481_;
                    break;
                }
                case WEST: {
                    hz = 1.0 - rayTraceResult.m_82450_().f_82479_;
                    hx = rayTraceResult.m_82450_().f_82481_;
                    break;
                }
                case EAST: {
                    hz = rayTraceResult.m_82450_().f_82479_;
                    hx = 1.0 - rayTraceResult.m_82450_().f_82481_;
                }
            }
            int index = -1;
            if (hx < 0.5 && hz < 0.5) {
                index = 1;
            } else if (hx >= 0.5 && hz < 0.5) {
                index = 0;
            } else if (hx < 0.5 && hz >= 0.5) {
                index = 3;
            } else if (hx >= 0.5 && hz >= 0.5) {
                index = 2;
            }
            if (index != -1 && (tileOven = (OvenBlockEntity)level.m_7702_(pos)) != null && tileOven.getToolItem(index).m_41619_()) {
                ItemStack toolItem = heldItem.m_41620_(1);
                tileOven.setToolItem(index, toolItem);
            }
            return InteractionResult.SUCCESS;
        }
        OvenBlockEntity oven = (OvenBlockEntity)level.m_7702_(pos);
        if (rayTraceResult.m_82434_() == state.m_61143_((Property)FACING) && oven != null) {
            if (player.m_6144_()) {
                oven.getDoorAnimator().toggleForcedOpen();
                return InteractionResult.SUCCESS;
            }
            if (!heldItem.m_41619_() && oven.getDoorAnimator().isForcedOpen()) {
                heldItem = ContainerUtils.insertItemStacked((Container)oven.getInputContainer(), (ItemStack)heldItem, (boolean)false);
                if (!heldItem.m_41619_()) {
                    heldItem = ContainerUtils.insertItemStacked((Container)oven.getFuelContainer(), (ItemStack)heldItem, (boolean)false);
                }
                player.m_21008_(hand, heldItem);
                return InteractionResult.SUCCESS;
            }
        }
        if (!level.f_46443_) {
            Balm.getNetworking().openGui(player, (MenuProvider)oven);
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new OvenBlockEntity(pos, state);
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        OvenBlockEntity tileEntity = (OvenBlockEntity)level.m_7702_(pos);
        if (tileEntity != null && tileEntity.isBurning()) {
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            float x = (float)pos.m_123341_() + 0.5f;
            float y = (float)pos.m_123342_() + 0.0f + OvenBlock.random.nextFloat() * 6.0f / 16.0f;
            float z = (float)pos.m_123343_() + 0.5f;
            float f3 = 0.52f;
            float f4 = OvenBlock.random.nextFloat() * 0.6f - 0.3f;
            if (facing == Direction.WEST) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)(x - f3), (double)y, (double)(z + f4), 0.0, 0.0, 0.0);
            } else if (facing == Direction.EAST) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)(x + f3), (double)y, (double)(z + f4), 0.0, 0.0, 0.0);
            } else if (facing == Direction.NORTH) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)(x + f4), (double)y, (double)(z - f3), 0.0, 0.0, 0.0);
            } else if (facing == Direction.SOUTH) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)(x + f4), (double)y, (double)(z + f3), 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tileEntity;
        if (newState.m_60734_() != state.m_60734_() && (tileEntity = level.m_7702_(pos)) instanceof OvenBlockEntity && ((OvenBlockEntity)tileEntity).hasPowerUpgrade()) {
            ItemUtils.spawnItemStack(level, (float)pos.m_123341_() + 0.5f, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, new ItemStack((ItemLike)ModItems.heatingUnit));
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return level.f_46443_ ? OvenBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.oven.get()), OvenBlockEntity::clientTick) : OvenBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.oven.get()), OvenBlockEntity::serverTick);
    }
}

