/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import net.blay09.mods.cookingforblockheads.block.FridgeBlock;
import net.blay09.mods.cookingforblockheads.client.ModModels;
import net.blay09.mods.cookingforblockheads.client.render.RenderUtils;
import net.blay09.mods.cookingforblockheads.tile.FridgeBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class FridgeRenderer
implements BlockEntityRenderer<FridgeBlockEntity> {
    private static final RandomSource random = RandomSource.m_216327_();

    public FridgeRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(FridgeBlockEntity tileEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        Level level = tileEntity.m_58904_();
        if (level == null) {
            return;
        }
        BlockState state = tileEntity.m_58900_();
        FridgeBlock.FridgeModelType fridgeModelType = (FridgeBlock.FridgeModelType)((Object)state.m_61143_(FridgeBlock.MODEL_TYPE));
        if (fridgeModelType == FridgeBlock.FridgeModelType.LARGE_UPPER) {
            return;
        }
        float doorAngle = tileEntity.getDoorAnimator().getRenderAngle(partialTicks);
        this.renderDoor(level, tileEntity, poseStack, buffer, state, fridgeModelType, doorAngle);
        if (doorAngle > 0.0f) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, 0.5, 0.0);
            RenderUtils.applyBlockAngle(poseStack, tileEntity.m_58900_());
            poseStack.m_85841_(0.3f, 0.3f, 0.3f);
            float topY = fridgeModelType == FridgeBlock.FridgeModelType.LARGE_LOWER ? 3.25f : 0.45f;
            Container container = tileEntity.getCombinedContainer();
            for (int i = container.m_6643_() - 1; i >= 0; --i) {
                float offsetZ;
                float offsetY;
                float offsetX;
                ItemStack itemStack = container.m_8020_(i);
                if (itemStack.m_41619_()) continue;
                if (fridgeModelType == FridgeBlock.FridgeModelType.LARGE_LOWER) {
                    rowIndex = i % 18;
                    offsetX = 0.7f - (float)(rowIndex % 9) * 0.175f;
                    offsetY = topY - (float)((int)((float)i / 18.0f)) * 1.25f;
                    offsetZ = 0.5f - (float)((int)((float)rowIndex / 9.0f)) * 0.9f;
                } else {
                    rowIndex = i % 13;
                    offsetX = 0.7f;
                    float spacing = 0.175f;
                    if (rowIndex / 9 > 0) {
                        offsetX -= 0.2f;
                        spacing *= 2.0f;
                    }
                    offsetX -= (float)(rowIndex % 9) * spacing;
                    offsetY = topY - (float)((int)((float)i / 14.0f)) * 1.25f;
                    offsetZ = 0.5f - (float)((int)((float)rowIndex / 9.0f)) * 0.9f;
                }
                poseStack.m_85836_();
                poseStack.m_85837_((double)offsetX, (double)offsetY, (double)offsetZ);
                poseStack.m_85845_(new Quaternion(0.0f, 45.0f, 0.0f, true));
                RenderUtils.renderItem(itemStack, combinedLight, poseStack, buffer);
                poseStack.m_85849_();
            }
            poseStack.m_85849_();
        }
    }

    private void renderDoor(Level level, FridgeBlockEntity tileEntity, PoseStack poseStack, MultiBufferSource buffer, BlockState state, FridgeBlock.FridgeModelType fridgeModelType, float doorAngle) {
        BakedModel lowerModel;
        boolean isFlipped = (Boolean)state.m_61143_((Property)FridgeBlock.FLIPPED);
        boolean isLarge = fridgeModelType == FridgeBlock.FridgeModelType.LARGE_LOWER;
        poseStack.m_85836_();
        RenderUtils.applyBlockAngle(poseStack, tileEntity.m_58900_());
        poseStack.m_85837_(-0.5, 0.0, -0.5);
        float originX = 0.90625f;
        float originZ = 0.09375f;
        if (isFlipped) {
            originX = 1.0f - originX;
            doorAngle *= -1.0f;
        }
        poseStack.m_85837_((double)originX, 0.0, (double)originZ);
        poseStack.m_85845_(new Quaternion(0.0f, -((float)Math.toDegrees(doorAngle)), 0.0f, true));
        poseStack.m_85837_((double)(-originX), 0.0, (double)(-originZ));
        BakedModel upperModel = null;
        if (isLarge) {
            lowerModel = isFlipped ? (BakedModel)ModModels.fridgeDoorLargeLowerFlipped.get() : (BakedModel)ModModels.fridgeDoorLargeLower.get();
            upperModel = isFlipped ? (BakedModel)ModModels.fridgeDoorLargeUpperFlipped.get() : (BakedModel)ModModels.fridgeDoorLargeUpper.get();
        } else {
            lowerModel = isFlipped ? (BakedModel)ModModels.fridgeDoorFlipped.get() : (BakedModel)ModModels.fridgeDoor.get();
        }
        BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
        dispatcher.m_110937_().m_234379_((BlockAndTintGetter)level, lowerModel, tileEntity.m_58900_(), tileEntity.m_58899_(), poseStack, buffer.m_6299_(RenderType.m_110451_()), false, random, 0L, 0);
        if (upperModel != null) {
            poseStack.m_85837_(0.0, 1.0, 0.0);
            dispatcher.m_110937_().m_234379_((BlockAndTintGetter)level, upperModel, tileEntity.m_58900_(), tileEntity.m_58899_().m_7494_(), poseStack, buffer.m_6299_(RenderType.m_110451_()), false, random, 0L, 0);
        }
        poseStack.m_85849_();
    }
}

