/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.tile;

import com.google.common.collect.Lists;
import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.block.entity.BalmBlockEntity;
import net.blay09.mods.balm.api.container.ContainerUtils;
import net.blay09.mods.balm.api.fluid.BalmFluidTankProvider;
import net.blay09.mods.balm.api.fluid.FluidTank;
import net.blay09.mods.balm.api.provider.BalmProvider;
import net.blay09.mods.cookingforblockheads.CookingForBlockheadsConfig;
import net.blay09.mods.cookingforblockheads.api.SourceItem;
import net.blay09.mods.cookingforblockheads.api.capability.AbstractKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.blay09.mods.cookingforblockheads.tile.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class SinkBlockEntity
extends BalmBlockEntity
implements BalmFluidTankProvider {
    private static final int SYNC_INTERVAL = 10;
    private final FluidTank sinkTank = new FluidTank(16000){

        public Fluid getFluid() {
            if (!CookingForBlockheadsConfig.getActive().sinkRequiresWater) {
                return Fluids.f_76193_;
            }
            return super.getFluid();
        }

        public int getAmount() {
            if (!CookingForBlockheadsConfig.getActive().sinkRequiresWater) {
                return Integer.MAX_VALUE;
            }
            return super.getAmount();
        }

        public int getCapacity() {
            if (!CookingForBlockheadsConfig.getActive().sinkRequiresWater) {
                return Integer.MAX_VALUE;
            }
            return super.getCapacity();
        }

        public int drain(Fluid fluid, int maxDrain, boolean simulate) {
            if (!CookingForBlockheadsConfig.getActive().sinkRequiresWater && fluid == Fluids.f_76193_) {
                return maxDrain;
            }
            if (fluid.m_6212_(Fluids.f_76191_) || !fluid.m_6212_(fluid)) {
                return 0;
            }
            SinkBlockEntity.this.m_6596_();
            return super.drain(fluid, maxDrain, simulate);
        }

        public int fill(Fluid fluid, int maxFill, boolean simulate) {
            if (!CookingForBlockheadsConfig.getActive().sinkRequiresWater) {
                return maxFill;
            }
            SinkBlockEntity.this.m_6596_();
            return super.fill(fluid, maxFill, simulate);
        }
    };
    private final SinkItemProvider itemProvider = new SinkItemProvider(this.sinkTank);
    private int ticksSinceSync;
    private boolean isDirty;
    private DyeColor color = DyeColor.WHITE;

    public SinkBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.sink.get(), pos, state);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("FluidTank", (Tag)this.sinkTank.serialize());
        tag.m_128344_("Color", (byte)this.color.m_41060_());
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.sinkTank.deserialize(tag.m_128469_("FluidTank"));
        this.color = DyeColor.m_41053_((int)tag.m_128445_("Color"));
    }

    public void writeUpdateTag(CompoundTag tag) {
        this.m_183515_(tag);
    }

    public List<BalmProvider<?>> getProviders() {
        return Lists.newArrayList((Object[])new BalmProvider[]{new BalmProvider(IKitchenItemProvider.class, (Object)this.itemProvider)});
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, SinkBlockEntity blockEntity) {
        blockEntity.serverTick(level, pos, state);
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        ++this.ticksSinceSync;
        if (this.ticksSinceSync >= 10) {
            this.ticksSinceSync = 0;
            if (this.isDirty) {
                this.sync();
                this.isDirty = false;
            }
        }
    }

    public void m_6596_() {
        super.m_6596_();
        this.isDirty = true;
    }

    public FluidTank getFluidTank() {
        return this.sinkTank;
    }

    private class SinkItemProvider
    extends AbstractKitchenItemProvider {
        private final NonNullList<ItemStack> itemStacks = NonNullList.m_122779_();
        private final FluidTank fluidTank;
        private int waterUsed;

        public SinkItemProvider(FluidTank fluidTank) {
            this.fluidTank = fluidTank;
            this.itemStacks.addAll(CookingRegistry.getWaterItems());
        }

        @Override
        public void resetSimulation() {
            this.waterUsed = 0;
        }

        @Override
        public int getSimulatedUseCount(int slot) {
            return this.waterUsed / 1000;
        }

        @Override
        public ItemStack useItemStack(int slot, int amount, boolean simulate, List<IKitchenItemProvider> inventories, boolean requireBucket) {
            int availableAmount = this.fluidTank.getAmount();
            if (simulate) {
                availableAmount -= this.waterUsed;
            }
            if (!CookingForBlockheadsConfig.getActive().sinkRequiresWater || availableAmount >= amount * 1000) {
                if (requireBucket && ((ItemStack)this.itemStacks.get(slot)).m_41720_() == Items.f_42455_ && !CookingRegistry.consumeBucket(inventories, simulate)) {
                    return ItemStack.f_41583_;
                }
                if (simulate) {
                    this.waterUsed += amount * 1000;
                } else {
                    this.fluidTank.drain((Fluid)Fluids.f_76193_, amount * 1000, false);
                    SinkBlockEntity.this.m_6596_();
                }
                return ContainerUtils.copyStackWithSize((ItemStack)((ItemStack)this.itemStacks.get(slot)), (int)amount);
            }
            return ItemStack.f_41583_;
        }

        @Override
        public ItemStack returnItemStack(ItemStack itemStack, SourceItem sourceItem) {
            for (ItemStack providedStack : this.itemStacks) {
                if (!Balm.getHooks().canItemsStack(itemStack, providedStack)) continue;
                this.fluidTank.fill((Fluid)Fluids.f_76193_, 1000, false);
                break;
            }
            return ItemStack.f_41583_;
        }

        @Override
        public int getSlots() {
            return this.itemStacks.size();
        }

        @Override
        public ItemStack getStackInSlot(int slot) {
            if (CookingForBlockheadsConfig.getActive().sinkRequiresWater && this.fluidTank.getAmount() - this.waterUsed < 1000) {
                return ItemStack.f_41583_;
            }
            return (ItemStack)this.itemStacks.get(slot);
        }
    }
}

