/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.api.element.transfer.path;

import java.util.List;
import net.minecraft.core.BlockPos;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;
import sirttas.elementalcraft.api.element.transfer.IElementTransferer;
import sirttas.elementalcraft.api.element.transfer.path.IElementTransferPathNode;

public interface IElementTransferPath
extends IElementTypeProvider {
    public boolean isValid();

    public void transfer();

    public List<IElementTransferPathNode> getNodes();

    public static void transfer(ElementType type, int amount, List<IElementTransferPathNode> nodes) {
        if (amount <= 0) {
            return;
        }
        int size = nodes.size();
        for (int i = 0; i < size - 1; ++i) {
            IElementTransferer transferer = nodes.get(i).getTransferer();
            if (transferer == null) continue;
            BlockPos from = i >= 1 ? nodes.get(i - 1).getPos() : null;
            BlockPos to = i < size - 1 ? nodes.get(i + 1).getPos() : null;
            transferer.onTransfer(type, amount, from, to);
        }
    }
}

