/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.api.source.trait.holder;

import java.util.Map;
import net.minecraft.resources.ResourceKey;
import net.minecraftforge.common.capabilities.AutoRegisterCapability;
import sirttas.elementalcraft.api.source.trait.SourceTrait;
import sirttas.elementalcraft.api.source.trait.value.ISourceTraitValue;

@AutoRegisterCapability
public interface ISourceTraitHolder {
    public Map<ResourceKey<SourceTrait>, ISourceTraitValue> getTraits();

    public void setTraits(Map<ResourceKey<SourceTrait>, ISourceTraitValue> var1);

    public boolean isArtificial();

    default public int getRecoverRate() {
        return Math.round(this.getTraits(SourceTrait.Type.RECOVER_RATE));
    }

    default public int getCapacity() {
        return Math.round(this.getTraits(SourceTrait.Type.CAPACITY));
    }

    default public float getSpeedModifier() {
        return this.getTraits(SourceTrait.Type.EXTRACTION_SPEED);
    }

    default public float getPreservationModifier() {
        return this.getTraits(SourceTrait.Type.PRESERVATION);
    }

    default public float getBreedingCost() {
        return this.getTraits(SourceTrait.Type.BREEDING_COST);
    }

    default public float getTraits(SourceTrait.Type type) {
        return (float)this.getTraits().values().stream().mapToDouble(traitValue -> traitValue.getValue(type)).reduce(1.0, (a, b) -> a * b);
    }

    default public boolean isEmpty() {
        return this.getTraits().isEmpty();
    }
}

