/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.evaporator;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.block.AbstractECContainerBlock;
import sirttas.elementalcraft.block.entity.BlockEntityHelper;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.evaporator.EvaporatorBlockEntity;
import sirttas.elementalcraft.item.elemental.ShardItem;
import sirttas.elementalcraft.particle.ParticleHelper;
import sirttas.elementalcraft.tag.ECTags;

public class EvaporatorBlock
extends AbstractECContainerBlock {
    public static final String NAME = "evaporator";
    private static final VoxelShape BASE_1 = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)1.0, (double)10.0);
    private static final VoxelShape BASE_2 = Block.m_49796_((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)7.0, (double)11.0);
    private static final VoxelShape PIPE_1 = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)5.0, (double)8.0, (double)5.0);
    private static final VoxelShape PIPE_2 = Block.m_49796_((double)11.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)5.0);
    private static final VoxelShape PIPE_3 = Block.m_49796_((double)3.0, (double)0.0, (double)11.0, (double)5.0, (double)8.0, (double)13.0);
    private static final VoxelShape PIPE_4 = Block.m_49796_((double)11.0, (double)0.0, (double)11.0, (double)13.0, (double)8.0, (double)13.0);
    private static final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)BASE_1, (VoxelShape[])new VoxelShape[]{BASE_2, PIPE_1, PIPE_2, PIPE_3, PIPE_4});

    public EvaporatorBlockEntity newBlockEntity(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new EvaporatorBlockEntity(pos, state);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<T> type) {
        return EvaporatorBlock.createECServerTicker(level, type, ECBlockEntityTypes.EVAPORATOR, EvaporatorBlockEntity::serverTick);
    }

    @Nonnull
    @Deprecated
    public InteractionResult m_6227_(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41619_() || EvaporatorBlock.getShardElementType(stack) != ElementType.NONE) {
            return this.onSingleSlotActivated(world, pos, player, hand);
        }
        return InteractionResult.PASS;
    }

    @Nonnull
    @Deprecated
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SHAPE;
    }

    @Deprecated
    public boolean m_7898_(@Nonnull BlockState state, @Nonnull LevelReader world, BlockPos pos) {
        return BlockEntityHelper.isValidContainer(state, world, pos.m_7495_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull RandomSource rand) {
        BlockEntityHelper.getBlockEntityAs((BlockGetter)world, pos, EvaporatorBlockEntity.class).filter(EvaporatorBlockEntity::canExtract).ifPresent(evaporator -> ParticleHelper.createElementFlowParticle(evaporator.getElementStorage().getElementType(), world, Vec3.m_82512_((Vec3i)pos.m_7495_()), Direction.DOWN, 1.0f, rand));
    }

    public static ElementType getShardElementType(ItemStack stack) {
        if (!stack.m_41619_()) {
            Item item = stack.m_41720_();
            if (stack.m_204117_(ECTags.Items.SHARDS) && item instanceof ShardItem) {
                ShardItem shardItem = (ShardItem)item;
                return shardItem.getElementType();
            }
        }
        return ElementType.NONE;
    }
}

