/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.source;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.block.source.SourceBlockEntity;
import sirttas.elementalcraft.block.source.SourceRendererHelper;
import sirttas.elementalcraft.renderer.ECRendererHelper;

public class SourceRenderer
implements BlockEntityRenderer<SourceBlockEntity> {
    public static final ResourceLocation STABILIZER_LOCATION = ElementalCraft.createRL("block/source_stabilizer");
    private BakedModel stabilizerModel;

    public void render(@Nonnull SourceBlockEntity source, float partialTicks, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, int light, int overlay) {
        Minecraft minecraft = Minecraft.m_91087_();
        ElementType elementType = source.getElementType();
        float r = elementType.getRed();
        float g = elementType.getGreen();
        float b = elementType.getBlue();
        if (this.stabilizerModel == null) {
            this.stabilizerModel = minecraft.m_91304_().getModel(STABILIZER_LOCATION);
        }
        SourceRendererHelper.renderSource(poseStack, buffer, partialTicks, light, overlay, elementType, source.isExhausted(), source.getRemainingRatio());
        if (source.isStabilized()) {
            poseStack.m_85837_(0.5, 0.0, 0.5);
            poseStack.m_85845_(Vector3f.f_122225_.m_122270_(ECRendererHelper.getClientTicks(partialTicks) / 20.0f));
            poseStack.m_85837_(-0.5, 0.0, -0.5);
            poseStack.m_85837_(0.0, -0.25, 0.0);
            minecraft.m_91289_().m_110937_().renderModel(poseStack.m_85850_(), buffer.m_6299_(RenderType.m_110466_()), source.m_58900_(), this.stabilizerModel, r, g, b, light, overlay, ECRendererHelper.getModelData(this.stabilizerModel, source), RenderType.m_110466_());
        }
    }
}

