/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.entity.player;

import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.network.message.MessageHelper;
import sirttas.elementalcraft.spell.Spell;
import sirttas.elementalcraft.spell.tick.ISpellTickManager;
import sirttas.elementalcraft.spell.tick.SpellTickCooldownMessage;
import sirttas.elementalcraft.spell.tick.SpellTickManager;

public class PlayerSpellTickManager
extends SpellTickManager {
    private final ServerPlayer player;

    public PlayerSpellTickManager(ServerPlayer player) {
        this.player = player;
    }

    @Nullable
    public static ICapabilityProvider createProvider(Player player) {
        SpellTickManager spellTickManager;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            spellTickManager = new PlayerSpellTickManager(serverPlayer);
        } else {
            spellTickManager = new SpellTickManager();
        }
        return new CapabilityProvider<SpellTickManager>(spellTickManager);
    }

    @Override
    public void startCooldown(Spell spell) {
        super.startCooldown(spell);
        MessageHelper.sendToPlayer(this.player, new SpellTickCooldownMessage(spell));
    }

    private record CapabilityProvider<T extends SpellTickManager>(T spellTickManager) implements ICapabilitySerializable<CompoundTag>
    {
        @NotNull
        public <U> LazyOptional<U> getCapability(@NotNull Capability<U> cap, @Nullable Direction side) {
            return ISpellTickManager.CAPABILITY.orEmpty(cap, LazyOptional.of(() -> this.spellTickManager));
        }

        public CompoundTag serializeNBT() {
            return ((SpellTickManager)this.spellTickManager).serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            ((SpellTickManager)this.spellTickManager).deserializeNBT(nbt);
        }
    }
}

