/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.interaction.ie.recipe;

import blusunrize.immersiveengineering.api.crafting.CrusherRecipe;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import sirttas.elementalcraft.api.rune.Rune;
import sirttas.elementalcraft.block.instrument.io.mill.grindstone.AirMillGrindstoneBlockEntity;
import sirttas.elementalcraft.recipe.instrument.io.grinding.IGrindingRecipe;

public class IECrusherRecipeWrapper
implements IGrindingRecipe {
    private final CrusherRecipe crushingRecipe;

    public IECrusherRecipeWrapper(CrusherRecipe crushingRecipe) {
        this.crushingRecipe = crushingRecipe;
    }

    @Override
    public int getElementAmount() {
        return 1000;
    }

    @Nonnull
    public NonNullList<Ingredient> m_7527_() {
        return this.crushingRecipe.m_7527_();
    }

    @Nonnull
    public ItemStack m_8043_() {
        return this.crushingRecipe.m_8043_();
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.crushingRecipe.m_6423_();
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return this.crushingRecipe.m_7707_();
    }

    @Override
    public boolean matches(ItemStack stack) {
        return this.crushingRecipe.input.test(stack) && IGrindingRecipe.super.matches(stack);
    }

    @Override
    @Nonnull
    public ItemStack assemble(@Nonnull AirMillGrindstoneBlockEntity instrument) {
        float luck = instrument.getRuneHandler().getBonus(Rune.BonusType.LUCK);
        ItemStack result = IGrindingRecipe.super.assemble(instrument);
        Level level = instrument.m_58904_();
        if (level == null) {
            return result;
        }
        RandomSource rand = level.m_213780_();
        this.crushingRecipe.secondaryOutputs.forEach(output -> {
            ItemStack stack = (ItemStack)output.stack().get();
            if (ItemStack.m_41746_((ItemStack)stack, (ItemStack)result) && rand.m_188501_() < output.chance() * luck) {
                result.m_41769_(stack.m_41613_());
            }
        });
        return result;
    }
}

