/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.interaction.mekanism.injector;

import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.inventory.IgnoredIInventory;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.InputIngredient;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.api.recipes.ingredients.creator.IChemicalStackIngredientCreator;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import mekanism.common.registration.impl.RecipeTypeRegistryObject;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import sirttas.elementalcraft.api.pureore.injector.AbstractPureOreRecipeInjector;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.tag.ECTags;

public abstract class AbstractMekanismPureOreRecipeInjector<T extends MekanismRecipe>
extends AbstractPureOreRecipeInjector<IgnoredIInventory, T> {
    private final RecipeTypeRegistryObject<T, ?> recipeTypeRegistryObject;

    protected AbstractMekanismPureOreRecipeInjector(RecipeTypeRegistryObject<T, ?> recipeType) {
        super(() -> recipeType.getRecipeType());
        this.recipeTypeRegistryObject = recipeType;
    }

    @Nonnull
    protected static ItemStackIngredient getInput(Ingredient ingredient, ItemStackIngredient old) {
        List representations = old.getRepresentations();
        if (!representations.isEmpty()) {
            return AbstractMekanismPureOreRecipeInjector.getInput(ingredient, (int)old.getNeededAmount((Object)((ItemStack)representations.get(0))));
        }
        return AbstractMekanismPureOreRecipeInjector.getInput(ingredient);
    }

    @Nonnull
    protected static ItemStackIngredient getInput(Ingredient ingredient) {
        return IngredientCreatorAccess.item().from(ingredient, AbstractMekanismPureOreRecipeInjector.getInputMultiplier(1L));
    }

    @Nonnull
    protected static ItemStackIngredient getInput(Ingredient ingredient, int size) {
        return IngredientCreatorAccess.item().from(ingredient, AbstractMekanismPureOreRecipeInjector.getInputMultiplier(size));
    }

    protected static ChemicalStackIngredient.GasStackIngredient tweakOutput(ChemicalStackIngredient.GasStackIngredient chemicalInput) {
        IChemicalStackIngredientCreator gas = IngredientCreatorAccess.gas();
        List<ChemicalStackIngredient.GasStackIngredient> ingredients = chemicalInput.getRepresentations().stream().map(s -> {
            GasStack copy = s.copy();
            copy.setAmount((long)AbstractMekanismPureOreRecipeInjector.getOutputMultiplier(chemicalInput.getNeededAmount(s)));
            return (ChemicalStackIngredient.GasStackIngredient)gas.from((ChemicalStack)copy);
        }).toList();
        if (ingredients.isEmpty()) {
            return chemicalInput;
        }
        if (ingredients.size() == 1) {
            return ingredients.get(0);
        }
        return (ChemicalStackIngredient.GasStackIngredient)gas.createMulti((InputIngredient[])((ChemicalStackIngredient.GasStackIngredient[])ingredients.toArray(ChemicalStackIngredient.GasStackIngredient[]::new)));
    }

    protected static ItemStack tweakOutput(ItemStack stack) {
        stack.m_41764_(AbstractMekanismPureOreRecipeInjector.getOutputMultiplier(stack.m_41613_()));
        return stack;
    }

    protected static <T extends Chemical<T>> ChemicalStack<T> tweakOutput(ChemicalStack<T> stack) {
        stack.setAmount((long)AbstractMekanismPureOreRecipeInjector.getOutputMultiplier(stack.getAmount()));
        return stack;
    }

    protected static int getInputMultiplier(long count) {
        return (int)Math.max(2L, count * (long)((Integer)ECConfig.COMMON.mekanismPureOreInputMultiplier.get()).intValue());
    }

    protected static int getOutputMultiplier(long count) {
        return (int)Math.max(2L, count * (long)((Integer)ECConfig.COMMON.mekanismPureOreOutputMultiplier.get()).intValue());
    }

    @Override
    public ResourceLocation getRecipeTypeRegistryName() {
        return new ResourceLocation("mekanism", this.recipeTypeRegistryObject.getInternalRegistryName());
    }

    @Override
    public boolean filter(T recipe, ItemStack stack) {
        return stack.m_204117_(ECTags.Items.PURE_SOURCE_ORES_ORES);
    }
}

