/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.item.source.receptacle;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;
import sirttas.elementalcraft.api.source.trait.holder.SourceTraitHolderHelper;
import sirttas.elementalcraft.block.source.trait.SourceTraits;
import sirttas.elementalcraft.item.ECItems;
import sirttas.elementalcraft.item.source.receptacle.ReceptacleHelper;

public class NaturalSourceIngredient
extends Ingredient
implements IElementTypeProvider {
    private final ElementType elementType;

    public NaturalSourceIngredient(ElementType elementType) {
        super(Stream.of(new Ingredient.Value[0]));
        this.elementType = elementType;
    }

    @Override
    public ElementType getElementType() {
        return this.elementType;
    }

    @Nonnull
    public ItemStack[] m_43908_() {
        return new ItemStack[]{ReceptacleHelper.create(this.elementType)};
    }

    public boolean m_43947_() {
        return false;
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null || !stack.m_150930_((Item)ECItems.RECEPTACLE.get())) {
            return false;
        }
        return SourceTraitHolderHelper.get((ICapabilityProvider)stack).map(t -> !t.getTraits().containsKey(SourceTraits.ARTIFICIAL)).orElse(true);
    }

    @Nonnull
    public JsonElement m_43942_() {
        JsonObject json = new JsonObject();
        json.addProperty("type", CraftingHelper.getID((IIngredientSerializer)Serializer.INSTANCE).toString());
        json.addProperty("element_type", this.elementType.m_7912_());
        return json;
    }

    @Nonnull
    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    implements IIngredientSerializer<NaturalSourceIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        @Nonnull
        public NaturalSourceIngredient parse(FriendlyByteBuf buffer) {
            return new NaturalSourceIngredient(ElementType.byName(buffer.m_130277_()));
        }

        @Nonnull
        public NaturalSourceIngredient parse(@Nonnull JsonObject json) {
            return new NaturalSourceIngredient(ElementType.byName(GsonHelper.m_13906_((JsonObject)json, (String)"element_type")));
        }

        public void write(FriendlyByteBuf buffer, NaturalSourceIngredient ingredient) {
            buffer.m_130070_(ingredient.elementType.m_7912_());
        }
    }
}

