/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.pureore;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.util.Supplier;
import sirttas.dpanvil.api.codec.Codecs;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.ElementalCraftUtils;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.api.pureore.injector.AbstractPureOreRecipeInjector;
import sirttas.elementalcraft.pureore.PureOre;
import sirttas.elementalcraft.tag.ECTags;

public record PureOreLoader(HolderSet<Item> source, Optional<ResourceLocation> fixedName, Optional<Pattern> tagPattern, List<Pattern> patterns, String namespace, Optional<Pattern> namespacePattern, int elementConsumption, int inputSize, int outputSize, double luckRatio, int order) {
    public static final String NAME = "pure_ore_loaders";
    public static final String FOLDER = "elementalcraft/pure_ore_loaders";
    public static Codec<PureOreLoader> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)RegistryCodecs.m_206277_((ResourceKey)Registry.f_122904_).fieldOf("source").forGetter(PureOreLoader::source), (App)ResourceLocation.f_135803_.optionalFieldOf("fixed_name").forGetter(PureOreLoader::fixedName), (App)Codecs.PATTERN.optionalFieldOf("tag_pattern").forGetter(PureOreLoader::tagPattern), (App)Codecs.PATTERN.listOf().optionalFieldOf("patterns", Collections.emptyList()).forGetter(PureOreLoader::patterns), (App)Codec.STRING.optionalFieldOf("namespace", (Object)"forge").forGetter(PureOreLoader::namespace), (App)Codecs.PATTERN.optionalFieldOf("namespace_pattern").forGetter(PureOreLoader::namespacePattern), (App)Codec.INT.optionalFieldOf("element_consumption", (Object)2500).forGetter(PureOreLoader::elementConsumption), (App)Codec.INT.optionalFieldOf("input_size", (Object)1).forGetter(PureOreLoader::inputSize), (App)Codec.INT.optionalFieldOf("output_size", (Object)2).forGetter(PureOreLoader::outputSize), (App)Codec.DOUBLE.optionalFieldOf("luck_ratio", (Object)0.0).forGetter(PureOreLoader::luckRatio), (App)Codec.INT.optionalFieldOf("order", (Object)1000).forGetter(PureOreLoader::order)).apply((Applicative)builder, PureOreLoader::new));
    private static final Pattern DEEPSLATE_PATTERN = Pattern.compile("^deepslate_");

    public PureOreLoader {
        if (fixedName.isEmpty() && tagPattern.isEmpty()) {
            throw new IllegalArgumentException("Either fixed_name or tag_folder must be set");
        }
        patterns = List.copyOf(patterns);
    }

    public List<PureOre> generate(Collection<AbstractPureOreRecipeInjector<?, ? extends Recipe<?>>> injectors) {
        return List.copyOf(this.generatePureOres(injectors).values());
    }

    private Map<ResourceLocation, PureOre> generatePureOres(Collection<AbstractPureOreRecipeInjector<?, ? extends Recipe<?>>> injectors) {
        List<Holder<Item>> list = this.streamSourceTag().toList();
        if (list.isEmpty()) {
            ElementalCraftApi.LOGGER.debug("No source items found for {}", new Supplier[]{this::getId});
            return Collections.emptyMap();
        }
        HashMap<ResourceLocation, PureOre> pureOres = new HashMap<ResourceLocation, PureOre>();
        ElementalCraftApi.LOGGER.info("Loading pure ores: {}.\r\n\tSource ores: {}", new Supplier[]{this::getId, () -> this.streamSourceTag().mapMulti(ElementalCraftUtils.cast(Holder.Reference.class)).map(r -> r.m_205785_().m_135782_().toString()).collect(Collectors.joining(", "))});
        list.forEach(holder -> {
            Item ore = (Item)holder.m_203334_();
            PureOre entry = this.findOrCreateEntry(pureOres, ore);
            boolean isInBlacklist = holder.m_203656_(ECTags.Items.PURE_ORES_MOD_PROCESSING_BLACKLIST);
            injectors.forEach(injector -> {
                block3: {
                    block2: {
                        if (!injector.isModProcessing()) break block2;
                        if (isInBlacklist) break block3;
                    }
                    injector.getRecipe(ore).ifPresent(entry::addRecipe);
                }
            });
        });
        return pureOres;
    }

    @Nonnull
    public ResourceLocation getId() {
        return ElementalCraft.PURE_ORE_LOADERS_MANAGER.getId((Object)this);
    }

    @Nonnull
    private Stream<Holder<Item>> streamSourceTag() {
        return this.source.m_203614_();
    }

    private PureOre findOrCreateEntry(Map<ResourceLocation, PureOre> pureOres, Item ore) {
        List<Object> tags;
        ResourceLocation id;
        for (PureOre pureOre : pureOres.values()) {
            if (!pureOre.contains(ore)) continue;
            return pureOre;
        }
        if (this.fixedName.isPresent()) {
            id = this.fixedName.get();
            tags = Collections.emptyList();
        } else if (this.tagPattern.isPresent()) {
            Pattern tp = this.tagPattern.get();
            Pattern np = this.namespacePattern.orElseGet(() -> Pattern.compile("^" + this.namespace + "$"));
            id = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)ore));
            tags = ore.m_204114_().m_203616_().filter(t -> {
                ResourceLocation location = t.f_203868_();
                return np.matcher(location.m_135827_()).find() && tp.matcher(location.m_135815_()).find();
            }).toList();
            if (!tags.isEmpty()) {
                if (tags.size() > 1) {
                    Supplier[] supplierArray = new Supplier[4];
                    supplierArray[0] = () -> ((ResourceLocation)id).toString();
                    supplierArray[1] = np::pattern;
                    supplierArray[2] = tp::pattern;
                    supplierArray[3] = () -> tags.stream().map(t -> t.f_203868_().toString()).collect(Collectors.joining(", "));
                    ElementalCraftApi.LOGGER.warn("Item {} has multiple tags matching \"{}:{}\":\r\n\t{}", supplierArray);
                }
                id = new ResourceLocation(this.namespace, this.cleanPath(tp.matcher(((TagKey)tags.get(0)).f_203868_().m_135815_()).replaceAll("")));
            } else {
                id = new ResourceLocation(id.m_135827_(), this.cleanPath(id.m_135815_()));
            }
        } else {
            throw new IllegalStateException("Either fixed_name or tag_folder must be set");
        }
        PureOre entry = pureOres.computeIfAbsent(id, i -> new PureOre((ResourceLocation)i, this.elementConsumption, this.inputSize, this.outputSize, this.luckRatio));
        entry.getOres().add(ore);
        tags.forEach(entry::addTag);
        return entry;
    }

    private String cleanPath(String path) {
        path = DEEPSLATE_PATTERN.matcher(path).replaceAll("");
        for (Pattern pattern : this.patterns) {
            path = pattern.matcher(path).replaceAll("");
        }
        return path;
    }

    public static Builder builder(HolderSet<Item> source) {
        return new Builder(source);
    }

    public static class Builder {
        private static final AtomicInteger ORDER_INCREMENT = new AtomicInteger(0);
        public static final Encoder<Builder> ENCODER = CODEC.comap(builder -> new PureOreLoader(builder.source, Optional.ofNullable(builder.fixedName), StringUtils.isNotBlank((CharSequence)builder.tagPattern) ? Optional.of(Pattern.compile(builder.tagPattern)) : Optional.empty(), builder.patterns.stream().map(Pattern::compile).toList(), builder.namespace, StringUtils.isNotBlank((CharSequence)builder.namespacePattern) ? Optional.of(Pattern.compile(builder.namespacePattern)) : Optional.empty(), builder.elementConsumption, builder.inputSize, builder.outputSize, builder.luckRatio, builder.order));
        private final HolderSet<Item> source;
        private ResourceLocation fixedName;
        private String tagPattern;
        private final List<String> patterns;
        private String namespace;
        private String namespacePattern;
        private int elementConsumption;
        private int inputSize;
        private int outputSize;
        private double luckRatio;
        private int order;

        private Builder(HolderSet<Item> source) {
            this.source = source;
            this.elementConsumption = 2500;
            this.inputSize = 1;
            this.outputSize = 2;
            this.luckRatio = 0.0;
            this.patterns = new ArrayList<String>();
            this.namespace = "forge";
            this.namespacePattern = "";
            this.tagPattern = "";
            this.order = ORDER_INCREMENT.getAndIncrement();
        }

        public Builder fixedName(ResourceLocation fixedName) {
            this.tagPattern = "";
            this.namespace = "forge";
            this.fixedName = fixedName;
            return this;
        }

        public Builder tagPattern(String tagPattern) {
            this.fixedName = null;
            this.tagPattern = tagPattern;
            return this;
        }

        public Builder pattern(String pattern) {
            this.patterns.add(pattern);
            return this;
        }

        public Builder patterns(String ... patterns) {
            this.patterns.addAll(Arrays.asList(patterns));
            return this;
        }

        public Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder namespacePattern(String namespacePattern) {
            this.namespacePattern = namespacePattern;
            return this;
        }

        public Builder consumption(int elementConsumption) {
            this.elementConsumption = elementConsumption;
            return this;
        }

        public Builder inputSize(int inputSize) {
            this.inputSize = inputSize;
            return this;
        }

        public Builder outputSize(int outputSize) {
            this.outputSize = outputSize;
            return this;
        }

        public Builder luckRatio(double luckRatio) {
            this.luckRatio = luckRatio;
            return this;
        }

        public Builder order(int order) {
            this.order = order;
            if (order >= ORDER_INCREMENT.get()) {
                ORDER_INCREMENT.set(order + 1);
            }
            return this;
        }
    }
}

