/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.spell.tick;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import sirttas.elementalcraft.spell.Spell;
import sirttas.elementalcraft.spell.tick.AbstractSpellInstance;
import sirttas.elementalcraft.spell.tick.ISpellTickManager;

public class SpellTickHelper {
    private SpellTickHelper() {
    }

    @Nonnull
    public static LazyOptional<ISpellTickManager> get(ICapabilityProvider provider) {
        return ISpellTickManager.CAPABILITY != null && provider != null ? provider.getCapability(ISpellTickManager.CAPABILITY, null) : LazyOptional.empty();
    }

    @Nonnull
    public static List<AbstractSpellInstance> getSpellInstances(ICapabilityProvider provider) {
        return SpellTickHelper.get(provider).map(ISpellTickManager::getSpellInstances).orElse(Collections.emptyList());
    }

    public static void startCooldown(ICapabilityProvider provider, Spell spell) {
        SpellTickHelper.get(provider).ifPresent(m -> m.startCooldown(spell));
    }

    public static boolean hasCooldown(ICapabilityProvider provider, Spell spell) {
        return SpellTickHelper.get(provider).map(m -> m.hasCooldown(spell)).orElse(false);
    }

    public static float getCooldown(ICapabilityProvider provider, Spell spell, float frameTime) {
        return SpellTickHelper.get(provider).map(m -> Float.valueOf(m.getCooldown(spell, frameTime))).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Nullable
    public static AbstractSpellInstance getSpellInstance(ICapabilityProvider provider, Spell spell) {
        return SpellTickHelper.get(provider).map(m -> m.getSpellInstance(spell)).orElse(null);
    }
}

