/*
 * Decompiled with CFR 0.152.
 */
package cofh.archersparadox.entity.projectile;

import cofh.archersparadox.init.APEntities;
import cofh.archersparadox.init.APItems;
import cofh.core.config.IBaseConfig;
import cofh.core.util.AreaUtils;
import cofh.lib.item.ArrowItemCoFH;
import cofh.lib.util.Utils;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.network.NetworkHooks;

public class BlazeArrow
extends AbstractArrow {
    private static final int CLOUD_DURATION = 20;
    public static float defaultDamage = 1.5f;
    public static int effectDuration = 10;
    public static int effectRadius = 2;
    public boolean discharged;
    public static final ArrowItemCoFH.IArrowFactory<AbstractArrow> FACTORY = new ArrowItemCoFH.IArrowFactory<AbstractArrow>(){

        public AbstractArrow createArrow(Level world, LivingEntity living) {
            return new BlazeArrow(world, living);
        }

        public AbstractArrow createArrow(Level world, double posX, double posY, double posZ) {
            return new BlazeArrow(world, posX, posY, posZ);
        }
    };
    public static final IBaseConfig CONFIG = new IBaseConfig(){
        private Supplier<Double> cfgDamage;
        private Supplier<Integer> cfgDuration;
        private Supplier<Integer> cfgRadius;

        public void apply(ForgeConfigSpec.Builder builder) {
            String name = "Blaze Arrow";
            builder.push(name);
            this.cfgDamage = builder.comment("Adjust this to set the damage for the " + name + ". Vanilla Arrow value is 2.0.").defineInRange("Damage", (double)defaultDamage, 0.0, 16.0);
            this.cfgDuration = builder.comment("Adjust this to set the burn duration for the " + name + " (in seconds). Nearby targets will burn for 5 seconds less than a direct target.").defineInRange("Burn Duration", effectDuration, 5, 30);
            this.cfgRadius = builder.comment("Adjust this to set the effect radius for the " + name + ". Set to 0 to disable, but that would be boring.").defineInRange("Radius", effectRadius, 0, 16);
            builder.pop();
        }

        public void refresh() {
            defaultDamage = this.cfgDamage.get().floatValue();
            effectDuration = this.cfgDuration.get();
            effectRadius = this.cfgRadius.get();
        }
    };

    public BlazeArrow(EntityType<? extends BlazeArrow> entityIn, Level worldIn) {
        super(entityIn, worldIn);
        this.f_36698_ = defaultDamage;
    }

    public BlazeArrow(Level worldIn, LivingEntity shooter) {
        super((EntityType)APEntities.BLAZE_ARROW.get(), shooter, worldIn);
        this.f_36698_ = defaultDamage;
    }

    public BlazeArrow(Level worldIn, double x, double y, double z) {
        super((EntityType)APEntities.BLAZE_ARROW.get(), x, y, z, worldIn);
        this.f_36698_ = defaultDamage;
    }

    protected ItemStack m_7941_() {
        return this.discharged ? new ItemStack((ItemLike)Items.f_42412_) : new ItemStack((ItemLike)APItems.BLAZE_ARROW_ITEM.get());
    }

    protected void m_6532_(HitResult raytraceResultIn) {
        super.m_6532_(raytraceResultIn);
        if (Utils.isServerWorld((Level)this.f_19853_) && !this.discharged && !this.m_20069_() && effectRadius > 0) {
            if (effectDuration - 5 > 0) {
                AreaUtils.igniteNearbyEntities((Entity)this, (Level)this.f_19853_, (BlockPos)this.m_20183_(), (int)effectRadius, (int)(effectDuration - 5));
            }
            AreaUtils.igniteSpecial((Entity)this, (Level)this.f_19853_, (BlockPos)this.m_20183_(), (int)effectRadius, (boolean)true, (boolean)true, (Entity)this.m_37282_());
            AreaUtils.igniteNearbyGround((Entity)this, (Level)this.f_19853_, (BlockPos)this.m_20183_(), (int)effectRadius, (double)0.1);
            this.makeAreaOfEffectCloud();
            this.discharged = true;
        }
    }

    protected void m_5790_(EntityHitResult raytraceResultIn) {
        super.m_5790_(raytraceResultIn);
        Entity entity = raytraceResultIn.m_82443_();
        if (!(entity.m_20147_() || entity.m_5825_() || this.m_20069_() || entity instanceof EnderMan)) {
            entity.m_20254_(effectDuration);
        }
    }

    public void m_20254_(int seconds) {
    }

    public void m_36762_(boolean critical) {
    }

    public void m_36735_(int knockbackStrengthIn) {
    }

    public void m_36767_(byte level) {
    }

    public void m_8119_() {
        super.m_8119_();
        if ((!this.f_36703_ || this.m_36797_()) && Utils.isClientWorld((Level)this.f_19853_) && !this.m_20069_()) {
            Vec3 vec3d = this.m_20184_();
            double d1 = vec3d.f_82479_;
            double d2 = vec3d.f_82480_;
            double d0 = vec3d.f_82481_;
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123756_, this.m_20185_() + d1 * 0.25, this.m_20186_() + d2 * 0.25, this.m_20189_() + d0 * 0.25, -d1, -d2 + 0.2, -d0);
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("ArrowData", this.discharged);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.discharged = compound.m_128471_("ArrowData");
    }

    public boolean m_6060_() {
        return !this.f_19853_.f_46443_;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    private void makeAreaOfEffectCloud() {
        AreaEffectCloud cloud = new AreaEffectCloud(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_());
        cloud.m_19712_(1.0f);
        cloud.m_19724_((ParticleOptions)ParticleTypes.f_123744_);
        cloud.m_19734_(20);
        cloud.m_19740_(0);
        cloud.m_19738_(((float)effectRadius - cloud.m_19743_()) / (float)cloud.m_19748_());
        this.f_19853_.m_7967_((Entity)cloud);
    }
}

