/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutilities.features.flatblocks;

import java.util.function.Supplier;
import net.darkhax.bookshelf.api.block.ILightningConductive;
import net.darkhax.darkutilities.features.flatblocks.BlockFlatTile;
import net.darkhax.darkutilities.features.flatblocks.BlockFlatTileRotatable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockFlatTileRotatableLightningUpgrade
extends BlockFlatTileRotatable
implements ILightningConductive {
    private final Supplier<Block> upgradeTo;

    public BlockFlatTileRotatableLightningUpgrade(Supplier<Block> upgradeTo) {
        this.upgradeTo = upgradeTo;
    }

    public BlockFlatTileRotatableLightningUpgrade(BlockFlatTile.CollisionEffect collisionEffect, Supplier<Block> upgradeTo) {
        super(collisionEffect);
        this.upgradeTo = upgradeTo;
    }

    public BlockFlatTileRotatableLightningUpgrade(BlockBehaviour.Properties properties, BlockFlatTile.CollisionEffect collisionEffect, Supplier<Block> upgradeTo) {
        super(properties, collisionEffect);
        this.upgradeTo = upgradeTo;
    }

    public void onDirectLightningStrike(Level world, BlockPos pos, BlockState state, LightningBolt lightning) {
        this.convertPlates(this.upgradeTo.get(), world, pos, 16);
    }

    public void onIndirectLightingStrike(Level world, BlockPos strikePos, BlockState strikeState, BlockPos indirectPos, BlockState indirectState, LightningBolt lightning) {
        this.convertPlates(this.upgradeTo.get(), world, indirectPos, 16);
    }

    private void convertPlates(Block to, Level world, BlockPos startPos, int attempts) {
        BlockPos.MutableBlockPos mutable = startPos.m_122032_();
        for (int attempt = 0; attempt < attempts; ++attempt) {
            Direction pointing = this.convertPlates(to, world, (BlockPos)mutable);
            if (pointing == null) {
                return;
            }
            mutable.m_122173_(pointing);
        }
    }

    private Direction convertPlates(Block to, Level world, BlockPos platePos) {
        BlockState state = world.m_8055_(platePos);
        if (state.m_60713_((Block)this)) {
            Direction plateDirection = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
            boolean platePowered = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_);
            world.m_46597_(platePos, (BlockState)((BlockState)to.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)plateDirection)).m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(platePowered)));
            world.m_46796_(3002, platePos, -1);
            return plateDirection;
        }
        return null;
    }
}

