/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.serverconfigupdater;

import com.darkere.serverconfigupdater.ServerConfigUpdater;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;

public class FileList
extends SimpleFileVisitor<Path> {
    private Map<Path, Path> files = new HashMap<Path, Path>();

    FileList() {
        try {
            Files.walkFileTree(Paths.get("", new String[0]), this);
        }
        catch (IOException e) {
            ServerConfigUpdater.LOGGER.warn("Error traversing files");
            e.printStackTrace();
        }
    }

    public void tryDeletingFiles() {
        List<Path> filesToDelete = ServerConfigUpdater.COMMON_CONFIG.getFilesToDelete();
        ServerConfigUpdater.LOGGER.info("Attempting to delete " + filesToDelete.size() + " files/folders defined in config");
        for (Path path : filesToDelete) {
            if (!this.files.containsKey(path.getFileName()) || !this.files.get(path.getFileName()).equals(path)) continue;
            try {
                File file = new File(String.valueOf(path));
                if (file.isDirectory() && file.listFiles().length != 0 && ServerConfigUpdater.COMMON_CONFIG.shouldDeleteFolders()) {
                    FileUtils.deleteDirectory((File)file);
                    ServerConfigUpdater.LOGGER.info("Successfully deleted folder " + path);
                    continue;
                }
                Files.delete(path);
                ServerConfigUpdater.LOGGER.info("Successfully deleted " + path);
            }
            catch (IOException e) {
                ServerConfigUpdater.LOGGER.error("error deleting files");
                e.printStackTrace();
            }
        }
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attr) {
        if (attr.isRegularFile()) {
            this.files.put(file.getFileName(), file);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        if (dir.endsWith("saves") || dir.endsWith("world")) {
            return FileVisitResult.SKIP_SUBTREE;
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
        if (!dir.equals(Paths.get("", new String[0]))) {
            this.files.put(dir.getFileName(), dir);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) {
        System.err.println(exc);
        return FileVisitResult.CONTINUE;
    }
}

