/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.blocks;

import com.shynieke.statues.blockentities.StatueBlockEntity;
import com.shynieke.statues.blocks.AbstractBaseBlock;
import com.shynieke.statues.registry.StatueBlockEntities;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class AbstractStatueBase
extends AbstractBaseBlock
implements EntityBlock {
    private static final VoxelShape SHAPE = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    public static final BooleanProperty INTERACTIVE = BooleanProperty.m_61465_((String)"interactive");

    public AbstractStatueBase(BlockBehaviour.Properties builder) {
        super(builder.m_60978_(0.6f));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)INTERACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player playerIn, InteractionHand handIn, BlockHitResult result) {
        if (!level.f_46443_ && handIn == InteractionHand.MAIN_HAND && this.canPlaySound(level, pos, state)) {
            level.m_5594_(null, pos, this.getSound(state), SoundSource.NEUTRAL, 1.0f, this.getPitch());
        }
        if (((Boolean)state.m_61143_((Property)INTERACTIVE)).booleanValue() && handIn == InteractionHand.MAIN_HAND && !level.f_46443_ && this.getBE((BlockGetter)level, pos) != null) {
            return this.getBE((BlockGetter)level, pos).interact(level, pos, state, playerIn, handIn, result);
        }
        return InteractionResult.SUCCESS;
    }

    public StatueBlockEntity getBE(BlockGetter getter, BlockPos pos) {
        BlockEntity blockEntity = getter.m_7702_(pos);
        if (blockEntity instanceof StatueBlockEntity) {
            StatueBlockEntity statueBlockEntity = (StatueBlockEntity)blockEntity;
            return statueBlockEntity;
        }
        return null;
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        StatueBlockEntity statueBlockEntity = this.getBE(level, pos);
        if (statueBlockEntity != null && statueBlockEntity.getUpgradeLevel("glowing") > 0) {
            return statueBlockEntity.getUpgradeLevel("glowing");
        }
        return super.getLightEmission(state, level, pos);
    }

    @Override
    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new StatueBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (((Boolean)state.m_61143_((Property)INTERACTIVE)).booleanValue()) {
            return AbstractStatueBase.createStatueTicker(level, blockEntityType, (BlockEntityType<? extends StatueBlockEntity>)((BlockEntityType)StatueBlockEntities.STATUE.get()));
        }
        return null;
    }

    @Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> createStatueTicker(Level level, BlockEntityType<T> blockEntityType, BlockEntityType<? extends StatueBlockEntity> blockEntityType1) {
        return level.f_46443_ ? null : AbstractStatueBase.m_152132_(blockEntityType, blockEntityType1, StatueBlockEntity::serverTick);
    }

    public ItemStack m_7397_(BlockGetter getter, BlockPos pos, BlockState state) {
        CompoundTag nbt;
        ItemStack itemstack = super.m_7397_(getter, pos, state);
        StatueBlockEntity statueBlockEntity = this.getBE(getter, pos);
        if (statueBlockEntity != null && ((Boolean)state.m_61143_((Property)INTERACTIVE)).booleanValue() && !(nbt = statueBlockEntity.saveToNbt(new CompoundTag())).m_128456_()) {
            itemstack.m_41700_("BlockEntityTag", (Tag)nbt);
        }
        return itemstack;
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity;
        if (((Boolean)state.m_61143_((Property)INTERACTIVE)).booleanValue() && (blockEntity = level.m_7702_(pos)) instanceof StatueBlockEntity) {
            StatueBlockEntity statueBlockEntity = (StatueBlockEntity)blockEntity;
            BlockEntity blockentity = level.m_7702_(pos);
            if (!level.f_46443_ && !player.m_150110_().f_35937_) {
                ItemStack itemstack = new ItemStack((ItemLike)this.m_5456_());
                statueBlockEntity.m_187476_(itemstack);
                blockentity.m_187476_(itemstack);
                ItemEntity itementity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, itemstack);
                itementity.m_32060_();
                level.m_7967_((Entity)itementity);
            }
        }
        super.m_5707_(level, pos, state, player);
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        if (((Boolean)state.m_61143_((Property)INTERACTIVE)).booleanValue()) {
            return new ArrayList<ItemStack>();
        }
        return super.m_7381_(state, builder);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, WATERLOGGED, INTERACTIVE});
    }

    public boolean m_7420_(BlockState state, BlockGetter getter, BlockPos pos) {
        return true;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            super.m_6810_(state, level, pos, newState, isMoving);
            level.m_46747_(pos);
        }
    }

    public boolean isHiddenStatue() {
        return false;
    }

    public boolean isBaby() {
        return false;
    }

    public EntityType<?> getEntity() {
        return EntityType.f_20483_;
    }

    public LivingEntity adjustSpawnedEntity(LivingEntity livingEntity) {
        return livingEntity;
    }

    public SoundEvent getSound(BlockState state) {
        return SoundEvents.f_11668_;
    }

    public float getPitch() {
        return this.isBaby() ? (RANDOM.m_188501_() - RANDOM.m_188501_()) * 0.2f + 1.5f : (RANDOM.m_188501_() - RANDOM.m_188501_()) * 0.2f + 1.0f;
    }

    public boolean canPlaySound(Level level, BlockPos pos, BlockState state) {
        StatueBlockEntity statueBlockEntity;
        BlockEntity blockEntity = level.m_7702_(pos);
        boolean flag = (Boolean)state.m_61143_((Property)INTERACTIVE) != false && blockEntity instanceof StatueBlockEntity && (statueBlockEntity = (StatueBlockEntity)blockEntity).makesSounds();
        boolean flag2 = level.m_8055_(pos.m_7495_()).m_60734_() instanceof NoteBlock;
        return flag || flag2;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!level.f_46443_ && this.canPlaySound(level, pos, state) && level.m_46753_(pos)) {
            level.m_5594_(null, pos, this.getSound(state), SoundSource.NEUTRAL, 1.0f, (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.2f + 1.5f);
        }
        super.m_6861_(state, level, pos, blockIn, fromPos, isMoving);
    }
}

