/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.client.screen;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class PlayerStatueData {
    public boolean small = false;
    public boolean locked = false;
    public boolean nameVisible = true;
    public boolean noGravity = false;
    public float yOffset = 0.0f;
    public float rotation = 0.0f;
    public String modelType = "AUTO";
    public final float[] pose = new float[21];

    public boolean isSmall() {
        return this.small;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public boolean getNameVisible() {
        return this.nameVisible;
    }

    public boolean hasNoGravity() {
        return this.noGravity;
    }

    public void readFromNBT(CompoundTag compound) {
        this.small = compound.m_128471_("Small");
        this.locked = compound.m_128471_("Locked");
        this.nameVisible = compound.m_128471_("CustomNameVisible");
        this.noGravity = compound.m_128471_("NoGravity");
        this.yOffset = compound.m_128457_("yOffset");
        this.modelType = compound.m_128461_("Model");
        if (compound.m_128441_("Rotation")) {
            this.rotation = compound.m_128437_("Rotation", 5).m_128775_(0);
        }
        if (compound.m_128441_("Pose")) {
            CompoundTag poseTag = (CompoundTag)compound.m_128423_("Pose");
            String[] keys = new String[]{"Head", "Body", "LeftLeg", "RightLeg", "LeftArm", "RightArm"};
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                if (!poseTag.m_128441_(key)) continue;
                ListTag tagList = poseTag.m_128437_(key, 5);
                for (int j = 0; j <= 2; ++j) {
                    int k = i * 3 + j;
                    this.pose[k] = tagList.m_128775_(j);
                }
            }
        }
    }

    public CompoundTag writeToNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128379_("Small", this.small);
        compound.m_128379_("Locked", this.locked);
        compound.m_128379_("CustomNameVisible", this.nameVisible);
        compound.m_128379_("NoGravity", this.noGravity);
        compound.m_128350_("yOffset", this.yOffset);
        compound.m_128359_("Model", this.modelType);
        ListTag rotationTag = new ListTag();
        rotationTag.add((Object)FloatTag.m_128566_((float)this.rotation));
        compound.m_128365_("Rotation", (Tag)rotationTag);
        CompoundTag poseTag = new CompoundTag();
        ListTag poseHeadTag = new ListTag();
        poseHeadTag.add((Object)FloatTag.m_128566_((float)this.pose[0]));
        poseHeadTag.add((Object)FloatTag.m_128566_((float)this.pose[1]));
        poseHeadTag.add((Object)FloatTag.m_128566_((float)this.pose[2]));
        poseTag.m_128365_("Head", (Tag)poseHeadTag);
        ListTag poseBodyTag = new ListTag();
        poseBodyTag.add((Object)FloatTag.m_128566_((float)this.pose[3]));
        poseBodyTag.add((Object)FloatTag.m_128566_((float)this.pose[4]));
        poseBodyTag.add((Object)FloatTag.m_128566_((float)this.pose[5]));
        poseTag.m_128365_("Body", (Tag)poseBodyTag);
        ListTag poseLeftLegTag = new ListTag();
        poseLeftLegTag.add((Object)FloatTag.m_128566_((float)this.pose[6]));
        poseLeftLegTag.add((Object)FloatTag.m_128566_((float)this.pose[7]));
        poseLeftLegTag.add((Object)FloatTag.m_128566_((float)this.pose[8]));
        poseTag.m_128365_("LeftLeg", (Tag)poseLeftLegTag);
        ListTag poseRightLegTag = new ListTag();
        poseRightLegTag.add((Object)FloatTag.m_128566_((float)this.pose[9]));
        poseRightLegTag.add((Object)FloatTag.m_128566_((float)this.pose[10]));
        poseRightLegTag.add((Object)FloatTag.m_128566_((float)this.pose[11]));
        poseTag.m_128365_("RightLeg", (Tag)poseRightLegTag);
        ListTag poseLeftArmTag = new ListTag();
        poseLeftArmTag.add((Object)FloatTag.m_128566_((float)this.pose[12]));
        poseLeftArmTag.add((Object)FloatTag.m_128566_((float)this.pose[13]));
        poseLeftArmTag.add((Object)FloatTag.m_128566_((float)this.pose[14]));
        poseTag.m_128365_("LeftArm", (Tag)poseLeftArmTag);
        ListTag poseRightArmTag = new ListTag();
        poseRightArmTag.add((Object)FloatTag.m_128566_((float)this.pose[15]));
        poseRightArmTag.add((Object)FloatTag.m_128566_((float)this.pose[16]));
        poseRightArmTag.add((Object)FloatTag.m_128566_((float)this.pose[17]));
        poseTag.m_128365_("RightArm", (Tag)poseRightArmTag);
        compound.m_128365_("Pose", (Tag)poseTag);
        return compound;
    }

    public static enum MODEL_TYPE {
        AUTO,
        DEFAULT,
        SLIM;

    }
}

