/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.entity;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.shynieke.statues.blockentities.PlayerBlockEntity;
import com.shynieke.statues.client.ClientHandler;
import com.shynieke.statues.client.screen.PlayerStatueData;
import com.shynieke.statues.network.StatuesNetworking;
import com.shynieke.statues.network.message.PlayerStatueScreenMessage;
import com.shynieke.statues.registry.StatueRegistry;
import com.shynieke.statues.registry.StatueSerializers;
import com.shynieke.statues.util.SkinUtil;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Rotations;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;

public class PlayerStatue
extends LivingEntity {
    private static final Rotations DEFAULT_HEAD_ROTATION = new Rotations(0.0f, 0.0f, 0.0f);
    private static final Rotations DEFAULT_BODY_ROTATION = new Rotations(0.0f, 0.0f, 0.0f);
    private static final Rotations DEFAULT_LEFTARM_ROTATION = new Rotations(-10.0f, 0.0f, -10.0f);
    private static final Rotations DEFAULT_RIGHTARM_ROTATION = new Rotations(-15.0f, 0.0f, 10.0f);
    private static final Rotations DEFAULT_LEFTLEG_ROTATION = new Rotations(-1.0f, 0.0f, -1.0f);
    private static final Rotations DEFAULT_RIGHTLEG_ROTATION = new Rotations(1.0f, 0.0f, 1.0f);
    private static final String DEFAULT_MODEL = PlayerStatueData.MODEL_TYPE.AUTO.name();
    private static final EntityDataAccessor<Optional<GameProfile>> GAMEPROFILE = SynchedEntityData.m_135353_(PlayerStatue.class, (EntityDataSerializer)((EntityDataSerializer)StatueSerializers.OPTIONAL_GAME_PROFILE.get()));
    public static final EntityDataAccessor<Byte> STATUS = SynchedEntityData.m_135353_(PlayerStatue.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public static final EntityDataAccessor<Float> Y_OFFSET = SynchedEntityData.m_135353_(PlayerStatue.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Rotations> HEAD_ROTATION = SynchedEntityData.m_135353_(PlayerStatue.class, (EntityDataSerializer)EntityDataSerializers.f_135037_);
    public static final EntityDataAccessor<Rotations> BODY_ROTATION = SynchedEntityData.m_135353_(PlayerStatue.class, (EntityDataSerializer)EntityDataSerializers.f_135037_);
    public static final EntityDataAccessor<Rotations> LEFT_ARM_ROTATION = SynchedEntityData.m_135353_(PlayerStatue.class, (EntityDataSerializer)EntityDataSerializers.f_135037_);
    public static final EntityDataAccessor<Rotations> RIGHT_ARM_ROTATION = SynchedEntityData.m_135353_(PlayerStatue.class, (EntityDataSerializer)EntityDataSerializers.f_135037_);
    public static final EntityDataAccessor<Rotations> LEFT_LEG_ROTATION = SynchedEntityData.m_135353_(PlayerStatue.class, (EntityDataSerializer)EntityDataSerializers.f_135037_);
    public static final EntityDataAccessor<Rotations> RIGHT_LEG_ROTATION = SynchedEntityData.m_135353_(PlayerStatue.class, (EntityDataSerializer)EntityDataSerializers.f_135037_);
    public static final EntityDataAccessor<String> MODEL_TYPE = SynchedEntityData.m_135353_(PlayerStatue.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Optional<UUID>> LOCKED_BY_UUID = SynchedEntityData.m_135353_(PlayerStatue.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private final NonNullList<ItemStack> handItems = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
    private final NonNullList<ItemStack> armorItems = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    public long punchCooldown;
    private int disabledSlots;
    private boolean isSlim = false;
    private Rotations headRotation = DEFAULT_HEAD_ROTATION;
    private Rotations bodyRotation = DEFAULT_BODY_ROTATION;
    private Rotations leftArmRotation = DEFAULT_LEFTARM_ROTATION;
    private Rotations rightArmRotation = DEFAULT_RIGHTARM_ROTATION;
    private Rotations leftLegRotation = DEFAULT_LEFTLEG_ROTATION;
    private Rotations rightLegRotation = DEFAULT_RIGHTLEG_ROTATION;
    public int clientLock = 0;

    public PlayerStatue(EntityType<? extends PlayerStatue> entityType, Level level) {
        super(entityType, level);
    }

    public void m_146922_(float yRot) {
        if (this.clientLock > 0) {
            return;
        }
        super.m_146922_(yRot);
    }

    public float getStepHeight() {
        return 0.0f;
    }

    public PlayerStatue(Level level, double posX, double posY, double posZ) {
        this((EntityType<? extends PlayerStatue>)((EntityType)StatueRegistry.PLAYER_STATUE_ENTITY.get()), level);
        this.m_6034_(posX, posY, posZ);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_6210_() {
        double d0 = this.m_20185_();
        double d1 = this.m_20186_();
        double d2 = this.m_20189_();
        super.m_6210_();
        this.m_6034_(d0, d1, d2);
    }

    private boolean hasPhysics() {
        return !this.m_20068_();
    }

    public boolean m_20068_() {
        return super.m_20068_();
    }

    public boolean m_6142_() {
        return super.m_6142_() && this.hasPhysics();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(GAMEPROFILE, Optional.empty());
        this.f_19804_.m_135372_(STATUS, (Object)0);
        this.f_19804_.m_135372_(Y_OFFSET, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(HEAD_ROTATION, (Object)DEFAULT_HEAD_ROTATION);
        this.f_19804_.m_135372_(BODY_ROTATION, (Object)DEFAULT_BODY_ROTATION);
        this.f_19804_.m_135372_(LEFT_ARM_ROTATION, (Object)DEFAULT_LEFTARM_ROTATION);
        this.f_19804_.m_135372_(RIGHT_ARM_ROTATION, (Object)DEFAULT_RIGHTARM_ROTATION);
        this.f_19804_.m_135372_(LEFT_LEG_ROTATION, (Object)DEFAULT_LEFTLEG_ROTATION);
        this.f_19804_.m_135372_(RIGHT_LEG_ROTATION, (Object)DEFAULT_RIGHTLEG_ROTATION);
        this.f_19804_.m_135372_(LOCKED_BY_UUID, Optional.empty());
        this.f_19804_.m_135372_(MODEL_TYPE, (Object)DEFAULT_MODEL);
    }

    public Optional<GameProfile> getGameProfile() {
        return (Optional)this.f_19804_.m_135370_(GAMEPROFILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGameProfile(GameProfile playerProfile) {
        PlayerBlockEntity.updateGameprofile(playerProfile, profile -> {
            this.f_19804_.m_135381_(GAMEPROFILE, Optional.of(profile));
            this.setSlim(profile != null && profile.getId() != null && SkinUtil.isSlimSkin(profile.getId()));
        });
        PlayerStatue playerStatue = this;
        synchronized (playerStatue) {
            this.getGameProfile().ifPresent(profile -> {
                if (this.f_19853_ != null && this.f_19853_.f_46443_ && profile != null && profile.isComplete()) {
                    Minecraft.m_91087_().m_91109_().m_118817_(profile, (textureType, textureLocation, profileTexture) -> {
                        if (textureType.equals((Object)MinecraftProfileTexture.Type.SKIN)) {
                            String metadata = profileTexture.getMetadata("model");
                            this.setSlim(metadata != null && metadata.equals("slim"));
                        }
                    }, true);
                }
            });
        }
    }

    @Nullable
    public boolean isLocked() {
        return ((Optional)this.f_19804_.m_135370_(LOCKED_BY_UUID)).isPresent();
    }

    @Nullable
    public UUID getLockedBy() {
        return ((Optional)this.f_19804_.m_135370_(LOCKED_BY_UUID)).orElse(null);
    }

    public String getModel() {
        return (String)this.f_19804_.m_135370_(MODEL_TYPE);
    }

    public void setModel(String model) {
        this.f_19804_.m_135381_(MODEL_TYPE, (Object)model);
    }

    public boolean canOpenUI(Player player) {
        UUID lockedBy = this.getLockedBy();
        return lockedBy == null || lockedBy != null && lockedBy.equals(player.m_20148_());
    }

    public void setLockedBy(@Nullable UUID uuid) {
        if (uuid == null) {
            this.setUnlocked();
        } else {
            this.f_19804_.m_135381_(LOCKED_BY_UUID, Optional.ofNullable(uuid));
        }
    }

    public void setUnlocked() {
        this.f_19804_.m_135381_(LOCKED_BY_UUID, Optional.empty());
    }

    public void setSlim(boolean slim) {
        this.isSlim = slim;
    }

    public boolean isSlim() {
        switch (this.getModel()) {
            case "SLIM": {
                return true;
            }
            case "DEFAULT": {
                return false;
            }
        }
        return this.isSlim;
    }

    public void setYOffset(float yOffset) {
        this.f_19804_.m_135381_(Y_OFFSET, (Object)Float.valueOf(Mth.m_14036_((float)yOffset, (float)-1.0f, (float)1.0f)));
    }

    public float getYOffsetData() {
        return ((Float)this.f_19804_.m_135370_(Y_OFFSET)).floatValue();
    }

    public Iterable<ItemStack> m_6167_() {
        return this.handItems;
    }

    public Iterable<ItemStack> m_6168_() {
        return this.armorItems;
    }

    public ItemStack m_6844_(EquipmentSlot slotIn) {
        return switch (slotIn.m_20743_()) {
            default -> throw new IncompatibleClassChangeError();
            case EquipmentSlot.Type.HAND -> (ItemStack)this.handItems.get(slotIn.m_20749_());
            case EquipmentSlot.Type.ARMOR -> (ItemStack)this.armorItems.get(slotIn.m_20749_());
        };
    }

    public void m_8061_(EquipmentSlot slotIn, ItemStack stack) {
        this.m_181122_(stack);
        switch (slotIn.m_20743_()) {
            case HAND: {
                this.m_238392_(slotIn, (ItemStack)this.handItems.set(slotIn.m_20749_(), (Object)stack), stack);
                break;
            }
            case ARMOR: {
                this.m_238392_(slotIn, (ItemStack)this.armorItems.set(slotIn.m_20749_(), (Object)stack), stack);
            }
        }
    }

    public boolean m_7066_(ItemStack itemstackIn) {
        EquipmentSlot equipmentslottype = PlayerStatue.m_147233_((ItemStack)itemstackIn);
        return this.m_6844_(equipmentslottype).m_41619_() && !this.isDisabled(equipmentslottype);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("gameProfileExists", ((Optional)this.f_19804_.m_135370_(GAMEPROFILE)).isPresent());
        if (this.getGameProfile().isPresent()) {
            compound.m_128365_("gameProfile", (Tag)NbtUtils.m_129230_((CompoundTag)new CompoundTag(), (GameProfile)((GameProfile)((Optional)this.f_19804_.m_135370_(GAMEPROFILE)).get())));
        }
        compound.m_128350_("yOffset", this.getYOffsetData());
        compound.m_128359_("Model", this.getModel());
        ListTag listnbt = new ListTag();
        for (ItemStack itemstack : this.armorItems) {
            CompoundTag compoundnbt = new CompoundTag();
            if (!itemstack.m_41619_()) {
                itemstack.m_41739_(compoundnbt);
            }
            listnbt.add((Object)compoundnbt);
        }
        compound.m_128365_("ArmorItems", (Tag)listnbt);
        ListTag listnbt1 = new ListTag();
        for (ItemStack itemstack1 : this.handItems) {
            CompoundTag compoundnbt1 = new CompoundTag();
            if (!itemstack1.m_41619_()) {
                itemstack1.m_41739_(compoundnbt1);
            }
            listnbt1.add((Object)compoundnbt1);
        }
        compound.m_128379_("Locked", this.isLocked());
        if (this.isLocked() && this.getLockedBy() != null) {
            compound.m_128362_("LockedBy", this.getLockedBy());
        }
        compound.m_128365_("HandItems", (Tag)listnbt1);
        compound.m_128379_("Small", this.isSmall());
        compound.m_128405_("DisabledSlots", this.disabledSlots);
        compound.m_128365_("Pose", (Tag)this.writePose());
    }

    public CompoundTag m_20240_(CompoundTag compound) {
        return super.m_20240_(compound);
    }

    public void m_20258_(CompoundTag compound) {
        super.m_20258_(compound);
        this.f_19804_.m_135381_(GAMEPROFILE, !compound.m_128471_("gameProfileExists") ? Optional.empty() : Optional.ofNullable(NbtUtils.m_129228_((CompoundTag)compound.m_128469_("gameProfile"))));
    }

    public void m_7378_(CompoundTag compound) {
        if (this.clientLock > 0) {
            return;
        }
        super.m_7378_(compound);
        this.setYOffset(compound.m_128457_("yOffset"));
        this.setModel(compound.m_128461_("Model"));
        if (compound.m_128425_("ArmorItems", 9)) {
            ListTag listnbt = compound.m_128437_("ArmorItems", 10);
            for (int i = 0; i < this.armorItems.size(); ++i) {
                this.armorItems.set(i, (Object)ItemStack.m_41712_((CompoundTag)listnbt.m_128728_(i)));
            }
        }
        if (compound.m_128471_("Locked")) {
            UUID uuid;
            if (compound.m_128403_("LockedBy")) {
                uuid = compound.m_128342_("LockedBy");
            } else {
                String s = compound.m_128461_("LockedBy");
                uuid = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s);
            }
            if (uuid != null) {
                this.setLockedBy(uuid);
            }
        }
        if (compound.m_128425_("HandItems", 9)) {
            ListTag listnbt1 = compound.m_128437_("HandItems", 10);
            for (int j = 0; j < this.handItems.size(); ++j) {
                this.handItems.set(j, (Object)ItemStack.m_41712_((CompoundTag)listnbt1.m_128728_(j)));
            }
        }
        this.setSmall(compound.m_128471_("Small"));
        this.disabledSlots = compound.m_128451_("DisabledSlots");
        this.f_19794_ = !this.hasPhysics();
        CompoundTag compoundnbt = compound.m_128469_("Pose");
        this.readPose(compoundnbt);
    }

    private void readPose(CompoundTag tagCompound) {
        ListTag listnbt = tagCompound.m_128437_("Head", 5);
        this.setHeadRotation(listnbt.isEmpty() ? DEFAULT_HEAD_ROTATION : new Rotations(listnbt));
        ListTag listnbt1 = tagCompound.m_128437_("Body", 5);
        this.setBodyRotation(listnbt1.isEmpty() ? DEFAULT_BODY_ROTATION : new Rotations(listnbt1));
        ListTag listnbt2 = tagCompound.m_128437_("LeftArm", 5);
        this.setLeftArmRotation(listnbt2.isEmpty() ? DEFAULT_LEFTARM_ROTATION : new Rotations(listnbt2));
        ListTag listnbt3 = tagCompound.m_128437_("RightArm", 5);
        this.setRightArmRotation(listnbt3.isEmpty() ? DEFAULT_RIGHTARM_ROTATION : new Rotations(listnbt3));
        ListTag listnbt4 = tagCompound.m_128437_("LeftLeg", 5);
        this.setLeftLegRotation(listnbt4.isEmpty() ? DEFAULT_LEFTLEG_ROTATION : new Rotations(listnbt4));
        ListTag listnbt5 = tagCompound.m_128437_("RightLeg", 5);
        this.setRightLegRotation(listnbt5.isEmpty() ? DEFAULT_RIGHTLEG_ROTATION : new Rotations(listnbt5));
    }

    private CompoundTag writePose() {
        CompoundTag compoundnbt = new CompoundTag();
        if (!DEFAULT_HEAD_ROTATION.equals((Object)this.headRotation)) {
            compoundnbt.m_128365_("Head", (Tag)this.headRotation.m_123155_());
        }
        if (!DEFAULT_BODY_ROTATION.equals((Object)this.bodyRotation)) {
            compoundnbt.m_128365_("Body", (Tag)this.bodyRotation.m_123155_());
        }
        if (!DEFAULT_LEFTARM_ROTATION.equals((Object)this.leftArmRotation)) {
            compoundnbt.m_128365_("LeftArm", (Tag)this.leftArmRotation.m_123155_());
        }
        if (!DEFAULT_RIGHTARM_ROTATION.equals((Object)this.rightArmRotation)) {
            compoundnbt.m_128365_("RightArm", (Tag)this.rightArmRotation.m_123155_());
        }
        if (!DEFAULT_LEFTLEG_ROTATION.equals((Object)this.leftLegRotation)) {
            compoundnbt.m_128365_("LeftLeg", (Tag)this.leftLegRotation.m_123155_());
        }
        if (!DEFAULT_RIGHTLEG_ROTATION.equals((Object)this.rightLegRotation)) {
            compoundnbt.m_128365_("RightLeg", (Tag)this.rightLegRotation.m_123155_());
        }
        return compoundnbt;
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_7324_(Entity entityIn) {
    }

    public void m_6593_(@Nullable Component name) {
        if (name != null && !this.isLocked()) {
            super.m_6593_(name);
            this.setGameProfile(new GameProfile((UUID)null, name.getString().toLowerCase(Locale.ROOT)));
        }
    }

    public InteractionResult m_7111_(Player player, Vec3 vec, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (player.m_6144_()) {
            if (!this.f_19853_.f_46443_ && player != null && this.canOpenUI(player)) {
                StatuesNetworking.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new PlayerStatueScreenMessage(this.m_19879_()));
            }
        } else if (itemstack.m_41720_() != Items.f_42656_) {
            if (player.m_5833_()) {
                return InteractionResult.SUCCESS;
            }
            if (player.f_19853_.f_46443_) {
                return InteractionResult.CONSUME;
            }
            if (!this.isLocked()) {
                EquipmentSlot equipmentSlot = Mob.m_147233_((ItemStack)itemstack);
                if (itemstack.m_41619_()) {
                    EquipmentSlot equipmentslot2;
                    EquipmentSlot equipmentslot1 = this.getClickedSlot(vec);
                    EquipmentSlot equipmentSlot2 = equipmentslot2 = this.isDisabled(equipmentslot1) ? equipmentSlot : equipmentslot1;
                    if (this.m_21033_(equipmentslot2) && this.swapItem(player, equipmentslot2, itemstack, hand)) {
                        return InteractionResult.SUCCESS;
                    }
                } else {
                    if (this.isDisabled(equipmentSlot)) {
                        return InteractionResult.FAIL;
                    }
                    if (this.swapItem(player, equipmentSlot, itemstack, hand)) {
                        return InteractionResult.SUCCESS;
                    }
                }
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EquipmentSlot getClickedSlot(Vec3 clicked) {
        EquipmentSlot equipmentslottype = EquipmentSlot.MAINHAND;
        boolean flag = this.isSmall();
        double d0 = flag ? clicked.f_82480_ * 2.0 : clicked.f_82480_;
        EquipmentSlot equipmentslottype1 = EquipmentSlot.FEET;
        if (d0 >= 0.1) {
            double d = flag ? 0.8 : 0.45;
            if (d0 < 0.1 + d && this.m_21033_(equipmentslottype1)) {
                return EquipmentSlot.FEET;
            }
        }
        double d = flag ? 0.3 : 0.0;
        if (d0 >= 0.9 + d) {
            double d2 = flag ? 1.0 : 0.7;
            if (d0 < 0.9 + d2 && this.m_21033_(EquipmentSlot.CHEST)) {
                return EquipmentSlot.CHEST;
            }
        }
        if (d0 >= 0.4) {
            double d3 = flag ? 1.0 : 0.8;
            if (d0 < 0.4 + d3 && this.m_21033_(EquipmentSlot.LEGS)) {
                return EquipmentSlot.LEGS;
            }
        }
        if (d0 >= 1.6 && this.m_21033_(EquipmentSlot.HEAD)) {
            return EquipmentSlot.HEAD;
        }
        if (this.m_21033_(EquipmentSlot.MAINHAND)) return equipmentslottype;
        if (!this.m_21033_(EquipmentSlot.OFFHAND)) return equipmentslottype;
        return EquipmentSlot.OFFHAND;
    }

    private boolean isDisabled(EquipmentSlot slotIn) {
        return (this.disabledSlots & 1 << slotIn.m_20750_()) != 0;
    }

    private boolean swapItem(Player player, EquipmentSlot slot, ItemStack stack, InteractionHand hand) {
        ItemStack itemstack = this.m_6844_(slot);
        if (!itemstack.m_41619_() && (this.disabledSlots & 1 << slot.m_20750_() + 8) != 0) {
            return false;
        }
        if (itemstack.m_41619_() && (this.disabledSlots & 1 << slot.m_20750_() + 16) != 0) {
            return false;
        }
        if (player.m_150110_().f_35937_ && itemstack.m_41619_() && !stack.m_41619_()) {
            ItemStack itemstack2 = stack.m_41777_();
            itemstack2.m_41764_(1);
            this.m_8061_(slot, itemstack2);
            return true;
        }
        if (!stack.m_41619_() && stack.m_41613_() > 1) {
            if (!itemstack.m_41619_()) {
                return false;
            }
            ItemStack itemstack1 = stack.m_41777_();
            itemstack1.m_41764_(1);
            this.m_8061_(slot, itemstack1);
            stack.m_41774_(1);
            return true;
        }
        this.m_8061_(slot, stack);
        player.m_21008_(hand, itemstack);
        return true;
    }

    public boolean m_20147_() {
        return this.isLocked() || super.m_20147_();
    }

    public boolean m_6673_(DamageSource source) {
        if (this.isLocked()) {
            return true;
        }
        return super.m_6673_(source);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (!this.f_19853_.f_46443_ && !this.m_213877_()) {
            if (DamageSource.f_19317_.equals(source)) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                return false;
            }
            if (!this.m_6673_(source)) {
                if (source.m_19372_()) {
                    this.brokenByAnything(source);
                    this.m_142687_(Entity.RemovalReason.KILLED);
                    return false;
                }
                if (DamageSource.f_19305_.equals(source)) {
                    if (this.m_6060_()) {
                        this.damageArmorStand(source, 0.15f);
                    } else {
                        this.m_20254_(5);
                    }
                    return false;
                }
                if (DamageSource.f_19307_.equals(source) && this.m_21223_() > 0.5f) {
                    this.damageArmorStand(source, 4.0f);
                    return false;
                }
                boolean flag = source.m_7640_() instanceof AbstractArrow;
                boolean flag1 = flag && ((AbstractArrow)source.m_7640_()).m_36796_() > 0;
                boolean flag2 = "player".equals(source.m_19385_());
                if (!flag2 && !flag) {
                    return false;
                }
                if (source.m_7639_() instanceof Player && !((Player)source.m_7639_()).m_150110_().f_35938_) {
                    return false;
                }
                if (source.m_19390_()) {
                    this.playBrokenSound();
                    this.playParticles();
                    this.m_142687_(Entity.RemovalReason.KILLED);
                    return flag1;
                }
                long i = this.f_19853_.m_46467_();
                if (i - this.punchCooldown > 5L && !flag) {
                    this.f_19853_.m_7605_((Entity)this, (byte)32);
                    this.punchCooldown = i;
                } else {
                    this.breakPlayerStatue(source);
                    this.playParticles();
                    this.m_142687_(Entity.RemovalReason.KILLED);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 32) {
            if (this.f_19853_.f_46443_) {
                this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11683_, this.m_5720_(), 0.3f, 1.0f, false);
                this.punchCooldown = this.f_19853_.m_46467_();
            }
        } else {
            super.m_7822_(id);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6783_(double distance) {
        double d0 = this.m_20191_().m_82309_() * 4.0;
        if (Double.isNaN(d0) || d0 == 0.0) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    private void playParticles() {
        if (this.f_19853_ instanceof ServerLevel) {
            ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, ((Block)StatueRegistry.PLAYER_STATUE.get()).m_49966_()), this.m_20185_(), this.m_20227_(0.6666666666666666), this.m_20189_(), 10, (double)(this.m_20205_() / 4.0f), (double)(this.m_20206_() / 4.0f), (double)(this.m_20205_() / 4.0f), 0.05);
        }
    }

    private void damageArmorStand(DamageSource source, float p_213817_2_) {
        float f = this.m_21223_();
        if ((f -= p_213817_2_) <= 0.5f) {
            this.brokenByAnything(source);
            this.m_142687_(Entity.RemovalReason.KILLED);
        } else {
            this.m_21153_(f);
        }
    }

    private void breakPlayerStatue(DamageSource source) {
        GameProfile profile;
        ItemStack stack = new ItemStack((ItemLike)StatueRegistry.PLAYER_STATUE.get());
        if (this.getGameProfile().isPresent() && (profile = this.getGameProfile().get()) != null) {
            CompoundTag stackTag = stack.m_41783_() != null ? stack.m_41783_() : new CompoundTag();
            CompoundTag nbttagcompound = new CompoundTag();
            NbtUtils.m_129230_((CompoundTag)nbttagcompound, (GameProfile)profile);
            stackTag.m_128365_("PlayerProfile", (Tag)nbttagcompound);
            stack.m_41751_(stackTag);
            stack.m_41714_((Component)Component.m_237113_((String)profile.getName()));
        }
        Block.m_49840_((Level)this.f_19853_, (BlockPos)this.m_20183_(), (ItemStack)stack);
        Block.m_49840_((Level)this.f_19853_, (BlockPos)this.m_20183_(), (ItemStack)new ItemStack((ItemLike)StatueRegistry.STATUE_CORE.get()));
        this.brokenByAnything(source);
    }

    public ItemStack getPickedResult(HitResult target) {
        GameProfile profile;
        ItemStack stack = new ItemStack((ItemLike)StatueRegistry.PLAYER_STATUE.get());
        if (this.getGameProfile().isPresent() && (profile = this.getGameProfile().get()) != null) {
            CompoundTag stackTag = stack.m_41783_() != null ? stack.m_41783_() : new CompoundTag();
            CompoundTag nbttagcompound = new CompoundTag();
            NbtUtils.m_129230_((CompoundTag)nbttagcompound, (GameProfile)profile);
            stackTag.m_128365_("PlayerProfile", (Tag)nbttagcompound);
            stack.m_41751_(stackTag);
            stack.m_41714_((Component)Component.m_237113_((String)profile.getName()));
        }
        return stack;
    }

    private void brokenByAnything(DamageSource source) {
        this.playBrokenSound();
        this.m_6668_(source);
        for (int i = 0; i < this.handItems.size(); ++i) {
            ItemStack itemstack = (ItemStack)this.handItems.get(i);
            if (itemstack.m_41619_()) continue;
            Block.m_49840_((Level)this.f_19853_, (BlockPos)this.m_20183_().m_7494_(), (ItemStack)itemstack);
            this.handItems.set(i, (Object)ItemStack.f_41583_);
        }
        for (int j = 0; j < this.armorItems.size(); ++j) {
            ItemStack itemstack1 = (ItemStack)this.armorItems.get(j);
            if (itemstack1.m_41619_()) continue;
            Block.m_49840_((Level)this.f_19853_, (BlockPos)this.m_20183_().m_7494_(), (ItemStack)itemstack1);
            this.armorItems.set(j, (Object)ItemStack.f_41583_);
        }
    }

    private void playBrokenSound() {
        this.f_19853_.m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11681_, this.m_5720_(), 1.0f, 1.0f);
    }

    protected float m_5632_(float p_110146_1_, float p_110146_2_) {
        this.f_20884_ = this.f_19859_;
        this.f_20883_ = this.m_146908_();
        return 0.0f;
    }

    protected float getStandingEdyeHeight(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_ * (this.m_6162_() ? 0.5f : 0.9f);
    }

    public double m_6049_() {
        return (double)0.1f + (double)this.getYOffsetData();
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.hasPhysics()) {
            super.m_7023_(travelVector);
        }
    }

    public void m_5618_(float offset) {
        this.f_20884_ = this.f_19859_ = offset;
        this.f_20886_ = this.f_20885_ = offset;
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }

    public void m_5616_(float rotation) {
        this.f_20884_ = this.f_19859_ = rotation;
        this.f_20886_ = this.f_20885_ = rotation;
    }

    public void m_8119_() {
        Rotations rotations5;
        Rotations rotations4;
        Rotations rotations3;
        Rotations rotations2;
        Rotations rotations1;
        super.m_8119_();
        if (this.f_19853_.f_46443_ && this.getGameProfile().isPresent() && ClientHandler.TRANSLATORS.contains(this.getGameProfile().get().getId())) {
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123809_, this.m_20185_(), this.m_20188_() + 1.0, this.m_20189_(), (double)((float)((double)this.f_19853_.f_46441_.m_188501_() - 0.5) * 3.0f + this.f_19796_.m_188501_()) - 0.5, (double)((float)((double)this.f_19853_.f_46441_.m_188501_() - 0.5) * 3.0f - this.f_19796_.m_188501_() - 1.0f), (double)((float)((double)this.f_19853_.f_46441_.m_188501_() - 0.5) * 3.0f + this.f_19796_.m_188501_()) - 0.5);
        }
        if (this.clientLock > 0) {
            --this.clientLock;
            return;
        }
        Rotations rotations = (Rotations)this.f_19804_.m_135370_(HEAD_ROTATION);
        if (!this.headRotation.equals((Object)rotations)) {
            this.setHeadRotation(rotations);
        }
        if (!this.bodyRotation.equals((Object)(rotations1 = (Rotations)this.f_19804_.m_135370_(BODY_ROTATION)))) {
            this.setBodyRotation(rotations1);
        }
        if (!this.leftArmRotation.equals((Object)(rotations2 = (Rotations)this.f_19804_.m_135370_(LEFT_ARM_ROTATION)))) {
            this.setLeftArmRotation(rotations2);
        }
        if (!this.rightArmRotation.equals((Object)(rotations3 = (Rotations)this.f_19804_.m_135370_(RIGHT_ARM_ROTATION)))) {
            this.setRightArmRotation(rotations3);
        }
        if (!this.leftLegRotation.equals((Object)(rotations4 = (Rotations)this.f_19804_.m_135370_(LEFT_LEG_ROTATION)))) {
            this.setLeftLegRotation(rotations4);
        }
        if (!this.rightLegRotation.equals((Object)(rotations5 = (Rotations)this.f_19804_.m_135370_(RIGHT_LEG_ROTATION)))) {
            this.setRightLegRotation(rotations5);
        }
    }

    public boolean m_6162_() {
        return this.isSmall();
    }

    public void m_6074_() {
        this.m_142687_(Entity.RemovalReason.KILLED);
    }

    private void setSmall(boolean small) {
        this.f_19804_.m_135381_(STATUS, (Object)this.setBit((Byte)this.f_19804_.m_135370_(STATUS), 1, small));
    }

    public boolean isSmall() {
        return ((Byte)this.f_19804_.m_135370_(STATUS) & 1) != 0;
    }

    private byte setBit(byte p_184797_1_, int p_184797_2_, boolean p_184797_3_) {
        p_184797_1_ = p_184797_3_ ? (byte)(p_184797_1_ | p_184797_2_) : (byte)(p_184797_1_ & ~p_184797_2_);
        return p_184797_1_;
    }

    public void setHeadRotation(Rotations vec) {
        this.headRotation = vec;
        this.f_19804_.m_135381_(HEAD_ROTATION, (Object)vec);
    }

    public void setBodyRotation(Rotations vec) {
        this.bodyRotation = vec;
        this.f_19804_.m_135381_(BODY_ROTATION, (Object)vec);
    }

    public void setLeftArmRotation(Rotations vec) {
        this.leftArmRotation = vec;
        this.f_19804_.m_135381_(LEFT_ARM_ROTATION, (Object)vec);
    }

    public void setRightArmRotation(Rotations vec) {
        this.rightArmRotation = vec;
        this.f_19804_.m_135381_(RIGHT_ARM_ROTATION, (Object)vec);
    }

    public void setLeftLegRotation(Rotations vec) {
        this.leftLegRotation = vec;
        this.f_19804_.m_135381_(LEFT_LEG_ROTATION, (Object)vec);
    }

    public void setRightLegRotation(Rotations vec) {
        this.rightLegRotation = vec;
        this.f_19804_.m_135381_(RIGHT_LEG_ROTATION, (Object)vec);
    }

    public Rotations getHeadRotation() {
        return this.headRotation;
    }

    public Rotations getBodyRotation() {
        return this.bodyRotation;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Rotations getLeftArmRotation() {
        return this.leftArmRotation;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Rotations getRightArmRotation() {
        return this.rightArmRotation;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Rotations getLeftLegRotation() {
        return this.leftLegRotation;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Rotations getRightLegRotation() {
        return this.rightLegRotation;
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean m_7313_(Entity entityIn) {
        return entityIn instanceof Player && !this.f_19853_.m_7966_((Player)entityIn, this.m_20183_());
    }

    protected SoundEvent m_5896_(int heightIn) {
        return SoundEvents.f_11682_;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_11683_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_11681_;
    }

    public void m_8038_(ServerLevel serverLevel, LightningBolt bolt) {
    }

    public boolean m_5801_() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_7350_(EntityDataAccessor<?> key) {
        if (STATUS.equals(key)) {
            this.m_6210_();
            boolean bl = this.f_19850_ = !this.m_213877_();
        }
        if (GAMEPROFILE.equals(key)) {
            PlayerStatue playerStatue = this;
            synchronized (playerStatue) {
                this.getGameProfile().ifPresent(profile -> {
                    if (this.f_19853_ != null && this.f_19853_.f_46443_ && profile != null && profile.isComplete()) {
                        Minecraft.m_91087_().m_91109_().m_118817_(profile, (textureType, textureLocation, profileTexture) -> {
                            if (textureType.equals((Object)MinecraftProfileTexture.Type.SKIN)) {
                                String metadata = profileTexture.getMetadata("model");
                                this.setSlim(metadata != null && metadata.equals("slim"));
                            }
                        }, true);
                    }
                });
            }
        }
        super.m_7350_(key);
    }

    public boolean m_5789_() {
        return false;
    }
}

