/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.entity;

import com.shynieke.statues.config.StatuesConfig;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;

public class StatueBatEntity
extends Bat {
    public StatueBatEntity(EntityType<? extends StatueBatEntity> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Bat.m_21552_().m_22268_(Attributes.f_22276_, 12.0);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        int random = this.m_217043_().m_188503_(10);
        if (random < 5) {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 40000, 2, true, false));
        }
        return super.m_6518_(level, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Entity entity;
        if (!source.m_19387_() && (entity = source.m_7640_()) instanceof LivingEntity) {
            LivingEntity entitylivingbase = (LivingEntity)entity;
            if (!source.m_19372_()) {
                entitylivingbase.m_6469_(DamageSource.m_19335_((Entity)this), 2.0f);
            }
        }
        return super.m_6469_(source, amount);
    }

    public static boolean canSpawnHere(EntityType<StatueBatEntity> batIn, LevelAccessor levelAccessor, MobSpawnType reason, BlockPos pos, RandomSource randomIn) {
        if (!((Boolean)StatuesConfig.COMMON.statueBatSpawning.get()).booleanValue()) {
            return false;
        }
        if (pos.m_123342_() >= levelAccessor.m_5736_()) {
            return false;
        }
        int i = levelAccessor.m_46803_(pos);
        int j = 4;
        if (StatueBatEntity.isNearHalloween()) {
            j = 7;
        } else if (randomIn.m_188499_()) {
            return false;
        }
        return i > randomIn.m_188503_(j) ? false : StatueBatEntity.m_217057_(batIn, (LevelAccessor)levelAccessor, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)randomIn);
    }

    private static boolean isNearHalloween() {
        LocalDate localdate = LocalDate.now();
        int i = localdate.get(ChronoField.DAY_OF_MONTH);
        int j = localdate.get(ChronoField.MONTH_OF_YEAR);
        return j == 10 && i >= 20 || j == 11 && i <= 3;
    }
}

