/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.handlers;

import com.shynieke.statues.blocks.AbstractStatueBase;
import com.shynieke.statues.blocks.statues.PlayerStatueBlock;
import com.shynieke.statues.registry.StatueRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SpecialHandler {
    @SubscribeEvent
    public void onCrafted(PlayerEvent.ItemCraftedEvent event) {
        ItemStack resultStack = event.getCrafting();
        if (resultStack.m_41720_() == ((Block)StatueRegistry.PLAYER_STATUE.get()).m_5456_()) {
            Player player = event.getEntity();
            if (player == null || player instanceof FakePlayer) {
                event.setCanceled(true);
            }
            player.m_6469_(DamageSource.f_19319_, player.m_21233_() / 2.0f);
            resultStack.m_41714_(player.m_7755_());
        }
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        if (!event.player.f_19853_.f_46443_) {
            Player player = event.player;
            Level level = player.f_19853_;
            BlockPos pos = player.m_20183_();
            AABB hitbox = new AABB((double)((float)pos.m_123341_() - 0.5f), (double)((float)pos.m_123342_() - 0.5f), (double)((float)pos.m_123343_() - 0.5f), (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f)).m_82363_(-3.0, -3.0, -3.0).m_82363_(3.0, 3.0, 3.0);
            for (ItemEntity itemE : player.f_19853_.m_45976_(ItemEntity.class, hitbox)) {
                CampfireData data;
                boolean requirementsFound;
                boolean lavaFound;
                if (itemE == null || !itemE.m_32055_().m_41720_().equals(Items.f_42415_)) continue;
                AABB bb = itemE.m_20191_().m_82310_(0.1, 0.1, 0.1);
                BlockPos lavaPos = itemE.m_20183_();
                if (level.m_6425_(itemE.m_20183_()).m_76152_() == Fluids.f_76195_) {
                    lavaFound = true;
                    lavaPos = itemE.m_20183_();
                } else if (level.m_8055_(itemE.m_20183_().m_7495_()).m_60734_() == Blocks.f_49991_) {
                    lavaFound = true;
                    lavaPos = itemE.m_20183_().m_7495_();
                } else {
                    lavaFound = false;
                }
                if (!(requirementsFound = (data = this.properStatuesFound(level, lavaPos.m_7494_(), (Block)StatueRegistry.PLAYER_STATUE.get(), (Block)StatueRegistry.CREEPER_STATUE.get())).getBool() != false && lavaFound)) continue;
                level.m_46597_(lavaPos, Blocks.f_50016_.m_49966_());
                level.m_46597_(data.getPos1(), Blocks.f_50016_.m_49966_());
                level.m_46597_(data.getPos2(), Blocks.f_50016_.m_49966_());
                level.m_46597_(lavaPos, (BlockState)((Block)StatueRegistry.CAMPFIRE_STATUE.get()).m_49966_().m_61124_((Property)AbstractStatueBase.INTERACTIVE, (Comparable)Boolean.valueOf(false)));
                level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, (double)lavaPos.m_7495_().m_123341_(), (double)lavaPos.m_7495_().m_123342_(), (double)lavaPos.m_7495_().m_123343_(), 0.0, 0.0, 0.0);
                itemE.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    public CampfireData properStatuesFound(Level level, BlockPos pos, Block block, Block block1) {
        CampfireData data = new CampfireData(false, pos, pos);
        BlockState northBlock = level.m_8055_(pos.m_121945_(Direction.NORTH));
        BlockState eastBlock = level.m_8055_(pos.m_121945_(Direction.EAST));
        BlockState southBlock = level.m_8055_(pos.m_121945_(Direction.SOUTH));
        BlockState westBlock = level.m_8055_(pos.m_121945_(Direction.WEST));
        if (this.isValidBlock(northBlock, block) && this.isValidBlock(southBlock, block1)) {
            data = new CampfireData(true, pos.m_121945_(Direction.NORTH), pos.m_121945_(Direction.SOUTH));
        } else if (this.isValidBlock(northBlock, block1) && this.isValidBlock(southBlock, block)) {
            data = new CampfireData(true, pos.m_121945_(Direction.NORTH), pos.m_121945_(Direction.SOUTH));
        } else if (this.isValidBlock(westBlock, block) && this.isValidBlock(eastBlock, block1)) {
            data = new CampfireData(true, pos.m_121945_(Direction.WEST), pos.m_121945_(Direction.EAST));
        } else if (this.isValidBlock(westBlock, block1) && this.isValidBlock(eastBlock, block)) {
            data = new CampfireData(true, pos.m_121945_(Direction.WEST), pos.m_121945_(Direction.EAST));
        }
        return data;
    }

    public boolean isValidBlock(BlockState state, Block block) {
        if (state.m_60734_() == block && state.m_60734_() instanceof AbstractStatueBase) {
            return (Boolean)state.m_61143_((Property)AbstractStatueBase.INTERACTIVE) == false;
        }
        return state.m_60734_() instanceof PlayerStatueBlock;
    }

    public static class CampfireData {
        private final boolean bool;
        private final BlockPos pos1;
        private final BlockPos pos2;

        public CampfireData(boolean bool, BlockPos pos1, BlockPos pos2) {
            this.bool = bool;
            this.pos1 = pos1;
            this.pos2 = pos2;
        }

        public Boolean getBool() {
            return this.bool;
        }

        public BlockPos getPos1() {
            return this.pos1;
        }

        public BlockPos getPos2() {
            return this.pos2;
        }
    }
}

