/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.config;

import cofh.core.config.IBaseConfig;
import cofh.thermal.core.util.managers.dynamo.CompressionFuelManager;
import cofh.thermal.core.util.managers.dynamo.DisenchantmentFuelManager;
import cofh.thermal.core.util.managers.dynamo.GourmandFuelManager;
import cofh.thermal.core.util.managers.dynamo.LapidaryFuelManager;
import cofh.thermal.core.util.managers.dynamo.MagmaticFuelManager;
import cofh.thermal.core.util.managers.dynamo.NumismaticFuelManager;
import cofh.thermal.core.util.managers.dynamo.StirlingFuelManager;
import cofh.thermal.lib.common.ThermalFlags;
import java.util.function.Supplier;
import net.minecraftforge.common.ForgeConfigSpec;

public class ThermalDynamoConfig
implements IBaseConfig {
    private Supplier<Integer> dynamoStirlingPower;
    private Supplier<Integer> dynamoCompressionPower;
    private Supplier<Integer> dynamoMagmaticPower;
    private Supplier<Integer> dynamoNumismaticPower;
    private Supplier<Integer> dynamoLapidaryPower;
    private Supplier<Integer> dynamoDisenchantmentPower;
    private Supplier<Integer> dynamoGourmandPower;

    public void apply(ForgeConfigSpec.Builder builder) {
        builder.push("Dynamos");
        if (((Boolean)ThermalFlags.getFlag((String)"dynamo_stirling").get()).booleanValue()) {
            builder.push("Stirling");
            this.dynamoStirlingPower = builder.comment("This sets the base power generation (RF/t) for the Stirling Dynamo.").defineInRange("Base Power", StirlingFuelManager.instance().getBasePower(), StirlingFuelManager.instance().getMinPower(), StirlingFuelManager.instance().getMaxPower());
            builder.pop();
        }
        if (((Boolean)ThermalFlags.getFlag((String)"dynamo_compression").get()).booleanValue()) {
            builder.push("Compression");
            this.dynamoCompressionPower = builder.comment("This sets the base power generation (RF/t) for the Compression Dynamo.").defineInRange("Base Power", CompressionFuelManager.instance().getBasePower(), CompressionFuelManager.instance().getMinPower(), CompressionFuelManager.instance().getMaxPower());
            builder.pop();
        }
        if (((Boolean)ThermalFlags.getFlag((String)"dynamo_magmatic").get()).booleanValue()) {
            builder.push("Magmatic");
            this.dynamoMagmaticPower = builder.comment("This sets the base power generation (RF/t) for the Magmatic Dynamo.").defineInRange("Base Power", MagmaticFuelManager.instance().getBasePower(), MagmaticFuelManager.instance().getMinPower(), MagmaticFuelManager.instance().getMaxPower());
            builder.pop();
        }
        if (((Boolean)ThermalFlags.getFlag((String)"dynamo_numismatic").get()).booleanValue()) {
            builder.push("Numismatic");
            this.dynamoNumismaticPower = builder.comment("This sets the base power generation (RF/t) for the Numismatic Dynamo.").defineInRange("Base Power", NumismaticFuelManager.instance().getBasePower(), NumismaticFuelManager.instance().getMinPower(), NumismaticFuelManager.instance().getMaxPower());
            builder.pop();
        }
        if (((Boolean)ThermalFlags.getFlag((String)"dynamo_lapidary").get()).booleanValue()) {
            builder.push("Lapidary");
            this.dynamoLapidaryPower = builder.comment("This sets the base power generation (RF/t) for the Lapidary Dynamo.").defineInRange("Base Power", LapidaryFuelManager.instance().getBasePower(), LapidaryFuelManager.instance().getMinPower(), LapidaryFuelManager.instance().getMaxPower());
            builder.pop();
        }
        if (((Boolean)ThermalFlags.getFlag((String)"dynamo_disenchantment").get()).booleanValue()) {
            builder.push("Disenchantment");
            this.dynamoDisenchantmentPower = builder.comment("This sets the base power generation (RF/t) for the Disenchantment Dynamo.").defineInRange("Base Power", DisenchantmentFuelManager.instance().getBasePower(), DisenchantmentFuelManager.instance().getMinPower(), DisenchantmentFuelManager.instance().getMaxPower());
            builder.pop();
        }
        if (((Boolean)ThermalFlags.getFlag((String)"dynamo_gourmand").get()).booleanValue()) {
            builder.push("Gourmand");
            this.dynamoGourmandPower = builder.comment("This sets the base power generation (RF/t) for the Gourmand Dynamo.").defineInRange("Base Power", GourmandFuelManager.instance().getBasePower(), GourmandFuelManager.instance().getMinPower(), GourmandFuelManager.instance().getMaxPower());
            builder.pop();
        }
        builder.pop();
    }

    public void refresh() {
        if (this.dynamoStirlingPower != null) {
            StirlingFuelManager.instance().setBasePower(this.dynamoStirlingPower.get().intValue());
        }
        if (this.dynamoCompressionPower != null) {
            CompressionFuelManager.instance().setBasePower(this.dynamoCompressionPower.get().intValue());
        }
        if (this.dynamoMagmaticPower != null) {
            MagmaticFuelManager.instance().setBasePower(this.dynamoMagmaticPower.get().intValue());
        }
        if (this.dynamoNumismaticPower != null) {
            NumismaticFuelManager.instance().setBasePower(this.dynamoNumismaticPower.get().intValue());
        }
        if (this.dynamoLapidaryPower != null) {
            LapidaryFuelManager.instance().setBasePower(this.dynamoLapidaryPower.get().intValue());
        }
        if (this.dynamoDisenchantmentPower != null) {
            DisenchantmentFuelManager.instance().setBasePower(this.dynamoDisenchantmentPower.get().intValue());
        }
        if (this.dynamoGourmandPower != null) {
            GourmandFuelManager.instance().setBasePower(this.dynamoGourmandPower.get().intValue());
        }
    }
}

