/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.config;

import cofh.core.config.IBaseConfig;
import cofh.thermal.core.util.managers.machine.BottlerRecipeManager;
import cofh.thermal.core.util.managers.machine.BrewerRecipeManager;
import cofh.thermal.core.util.managers.machine.CentrifugeRecipeManager;
import cofh.thermal.core.util.managers.machine.ChillerRecipeManager;
import cofh.thermal.core.util.managers.machine.CrafterRecipeManager;
import cofh.thermal.core.util.managers.machine.CrucibleRecipeManager;
import cofh.thermal.core.util.managers.machine.CrystallizerRecipeManager;
import cofh.thermal.core.util.managers.machine.FurnaceRecipeManager;
import cofh.thermal.core.util.managers.machine.InsolatorRecipeManager;
import cofh.thermal.core.util.managers.machine.PressRecipeManager;
import cofh.thermal.core.util.managers.machine.PulverizerRecipeManager;
import cofh.thermal.core.util.managers.machine.PyrolyzerRecipeManager;
import cofh.thermal.core.util.managers.machine.RefineryRecipeManager;
import cofh.thermal.core.util.managers.machine.SawmillRecipeManager;
import cofh.thermal.core.util.managers.machine.SmelterRecipeManager;
import cofh.thermal.lib.common.ThermalFlags;
import java.util.function.Supplier;
import net.minecraftforge.common.ForgeConfigSpec;

public class ThermalMachineConfig
implements IBaseConfig {
    private Supplier<Integer> machineFurnacePower;
    private Supplier<Integer> machineSawmillPower;
    private Supplier<Integer> machinePulverizerPower;
    private Supplier<Integer> machineSmelterPower;
    private Supplier<Integer> machineInsolatorPower;
    private Supplier<Integer> machineCentrifugePower;
    private Supplier<Integer> machinePressPower;
    private Supplier<Integer> machineCruciblePower;
    private Supplier<Integer> machineChillerPower;
    private Supplier<Integer> machineRefineryPower;
    private Supplier<Integer> machinePyrolyzerPower;
    private Supplier<Integer> machineBottlerPower;
    private Supplier<Integer> machineBrewerPower;
    private Supplier<Integer> machineCrystallizerPower;
    private Supplier<Integer> machineCrafterPower;

    public void apply(ForgeConfigSpec.Builder builder) {
        builder.push("Machines");
        if (((Boolean)ThermalFlags.getFlag((String)"machine_furnace").get()).booleanValue()) {
            builder.push("Furnace");
            this.machineFurnacePower = builder.comment("This sets the base power consumption (RF/t) for the Redstone Furnace.").defineInRange("Base Power", FurnaceRecipeManager.instance().getBasePower(), FurnaceRecipeManager.instance().getMinPower(), FurnaceRecipeManager.instance().getMaxPower());
            builder.pop();
        }
        if (((Boolean)ThermalFlags.getFlag((String)"machine_sawmill").get()).booleanValue()) {
            builder.push("Sawmill");
            this.machineSawmillPower = builder.comment("This sets the base power consumption (RF/t) for the Sawmill.").defineInRange("Base Power", SawmillRecipeManager.instance().getBasePower(), SawmillRecipeManager.instance().getMinPower(), SawmillRecipeManager.instance().getMaxPower());
            builder.pop();
        }
        if (((Boolean)ThermalFlags.getFlag((String)"machine_pulverizer").get()).booleanValue()) {
            builder.push("Pulverizer");
            this.machinePulverizerPower = builder.comment("This sets the base power consumption (RF/t) for the Pulverizer.").defineInRange("Base Power", PulverizerRecipeManager.instance().getBasePower(), PulverizerRecipeManager.instance().getMinPower(), PulverizerRecipeManager.instance().getMaxPower());
            builder.pop();
        }
        if (((Boolean)ThermalFlags.getFlag((String)"machine_smelter").get()).booleanValue()) {
            builder.push("Smelter");
            this.machineSmelterPower = builder.comment("This sets the base power consumption (RF/t) for the Induction Smelter.").defineInRange("Base Power", SmelterRecipeManager.instance().getBasePower(), SmelterRecipeManager.instance().getMinPower(), SmelterRecipeManager.instance().getMaxPower());
            builder.pop();
        }
        if (((Boolean)ThermalFlags.getFlag((String)"machine_insolator").get()).booleanValue()) {
            builder.push("Insolator");
            this.machineInsolatorPower = builder.comment("This sets the base power consumption (RF/t) for the Phytogenic Insolator.").defineInRange("Base Power", InsolatorRecipeManager.instance().getBasePower(), InsolatorRecipeManager.instance().getMinPower(), InsolatorRecipeManager.instance().getMaxPower());
            builder.pop();
        }
        if (((Boolean)ThermalFlags.getFlag((String)"machine_centrifuge").get()).booleanValue()) {
            builder.push("Centrifuge");
            this.machineCentrifugePower = builder.comment("This sets the base power consumption (RF/t) for the Centrifugal Separator.").defineInRange("Base Power", CentrifugeRecipeManager.instance().getBasePower(), CentrifugeRecipeManager.instance().getMinPower(), CentrifugeRecipeManager.instance().getMaxPower());
            builder.pop();
        }
        if (((Boolean)ThermalFlags.getFlag((String)"machine_press").get()).booleanValue()) {
            builder.push("Press");
            this.machinePressPower = builder.comment("This sets the base power consumption (RF/t) for the Multiservo Press.").defineInRange("Base Power", PressRecipeManager.instance().getBasePower(), PressRecipeManager.instance().getMinPower(), PressRecipeManager.instance().getMaxPower());
            builder.pop();
        }
        if (((Boolean)ThermalFlags.getFlag((String)"machine_crucible").get()).booleanValue()) {
            builder.push("Crucible");
            this.machineCruciblePower = builder.comment("This sets the base power consumption (RF/t) for the Magma Crucible.").defineInRange("Base Power", CrucibleRecipeManager.instance().getBasePower(), CrucibleRecipeManager.instance().getMinPower(), CrucibleRecipeManager.instance().getMaxPower());
            builder.pop();
        }
        if (((Boolean)ThermalFlags.getFlag((String)"machine_chiller").get()).booleanValue()) {
            builder.push("Chiller");
            this.machineChillerPower = builder.comment("This sets the base power consumption (RF/t) for the Blast Chiller.").defineInRange("Base Power", ChillerRecipeManager.instance().getBasePower(), ChillerRecipeManager.instance().getMinPower(), ChillerRecipeManager.instance().getMaxPower());
            builder.pop();
        }
        if (((Boolean)ThermalFlags.getFlag((String)"machine_furnace").get()).booleanValue()) {
            builder.push("Refinery");
            this.machineRefineryPower = builder.comment("This sets the base power consumption (RF/t) for the Fractionating Still.").defineInRange("Base Power", RefineryRecipeManager.instance().getBasePower(), RefineryRecipeManager.instance().getMinPower(), RefineryRecipeManager.instance().getMaxPower());
            builder.pop();
        }
        if (((Boolean)ThermalFlags.getFlag((String)"machine_pyrolyzer").get()).booleanValue()) {
            builder.push("Pyrolyzer");
            this.machinePyrolyzerPower = builder.comment("This sets the base power consumption (RF/t) for the Pyrolyzer.").defineInRange("Base Power", PyrolyzerRecipeManager.instance().getBasePower(), PyrolyzerRecipeManager.instance().getMinPower(), PyrolyzerRecipeManager.instance().getMaxPower());
            builder.pop();
        }
        if (((Boolean)ThermalFlags.getFlag((String)"machine_bottler").get()).booleanValue()) {
            builder.push("Bottler");
            this.machineBottlerPower = builder.comment("This sets the base power consumption (RF/t) for the Fluid Encapsulator.").defineInRange("Base Power", BottlerRecipeManager.instance().getBasePower(), BottlerRecipeManager.instance().getMinPower(), BottlerRecipeManager.instance().getMaxPower());
            builder.pop();
        }
        if (((Boolean)ThermalFlags.getFlag((String)"machine_brewer").get()).booleanValue()) {
            builder.push("Brewer");
            this.machineBrewerPower = builder.comment("This sets the base power consumption (RF/t) for the Alchemical Imbuer.").defineInRange("Base Power", BrewerRecipeManager.instance().getBasePower(), BrewerRecipeManager.instance().getMinPower(), BrewerRecipeManager.instance().getMaxPower());
            builder.pop();
        }
        if (((Boolean)ThermalFlags.getFlag((String)"machine_crystallizer").get()).booleanValue()) {
            builder.push("Brewer");
            this.machineCrystallizerPower = builder.comment("This sets the base power consumption (RF/t) for the Crystallizer.").defineInRange("Base Power", CrystallizerRecipeManager.instance().getBasePower(), CrystallizerRecipeManager.instance().getMinPower(), CrystallizerRecipeManager.instance().getMaxPower());
            builder.pop();
        }
        if (((Boolean)ThermalFlags.getFlag((String)"machine_crafter").get()).booleanValue()) {
            builder.push("Crafter");
            this.machineCrafterPower = builder.comment("This sets the base power consumption (RF/t) for the Sequential Fabricator.").defineInRange("Base Power", CrafterRecipeManager.instance().getBasePower(), CrafterRecipeManager.instance().getMinPower(), CrafterRecipeManager.instance().getMaxPower());
            builder.pop();
        }
        builder.pop();
    }

    public void refresh() {
        if (this.machineFurnacePower != null) {
            FurnaceRecipeManager.instance().setBasePower(this.machineFurnacePower.get().intValue());
        }
        if (this.machineSawmillPower != null) {
            SawmillRecipeManager.instance().setBasePower(this.machineSawmillPower.get().intValue());
        }
        if (this.machinePulverizerPower != null) {
            PulverizerRecipeManager.instance().setBasePower(this.machinePulverizerPower.get().intValue());
        }
        if (this.machineSmelterPower != null) {
            SmelterRecipeManager.instance().setBasePower(this.machineSmelterPower.get().intValue());
        }
        if (this.machineInsolatorPower != null) {
            InsolatorRecipeManager.instance().setBasePower(this.machineInsolatorPower.get().intValue());
        }
        if (this.machineCentrifugePower != null) {
            CentrifugeRecipeManager.instance().setBasePower(this.machineCentrifugePower.get().intValue());
        }
        if (this.machinePressPower != null) {
            PressRecipeManager.instance().setBasePower(this.machinePressPower.get().intValue());
        }
        if (this.machineCruciblePower != null) {
            CrucibleRecipeManager.instance().setBasePower(this.machineCruciblePower.get().intValue());
        }
        if (this.machineChillerPower != null) {
            ChillerRecipeManager.instance().setBasePower(this.machineChillerPower.get().intValue());
        }
        if (this.machineRefineryPower != null) {
            RefineryRecipeManager.instance().setBasePower(this.machineRefineryPower.get().intValue());
        }
        if (this.machinePyrolyzerPower != null) {
            PyrolyzerRecipeManager.instance().setBasePower(this.machinePyrolyzerPower.get().intValue());
        }
        if (this.machineBottlerPower != null) {
            BottlerRecipeManager.instance().setBasePower(this.machineBottlerPower.get().intValue());
        }
        if (this.machineBrewerPower != null) {
            BrewerRecipeManager.instance().setBasePower(this.machineBrewerPower.get().intValue());
        }
        if (this.machineCrystallizerPower != null) {
            CrystallizerRecipeManager.instance().setBasePower(this.machineCrystallizerPower.get().intValue());
        }
        if (this.machineCrafterPower != null) {
            CrafterRecipeManager.instance().setBasePower(this.machineCrafterPower.get().intValue());
        }
    }
}

