/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.packcompanion.features.spawners;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.BlockEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.ftb.packcompanion.config.PCServerConfig;
import dev.ftb.packcompanion.features.ServerFeature;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundCustomSoundPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpawnerManager
extends ServerFeature {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpawnerManager.class);
    private static SpawnerManager INSTANCE = new SpawnerManager();
    private DataStore dataStore;
    private final Supplier<List<EntityType<?>>> randomEntities = Suppliers.memoize(() -> {
        List randomEntities = (List)PCServerConfig.SPAWNERS_USE_RANDOM_ENTITY.get();
        ArrayList<EntityType> entities = new ArrayList<EntityType>();
        for (String entity : randomEntities) {
            EntityType entityType = (EntityType)Registry.f_122826_.m_7745_(new ResourceLocation(entity));
            if (entityType == EntityType.f_20510_ && !entity.endsWith("pig")) continue;
            entities.add(entityType);
        }
        return entities;
    });

    @Override
    public void initialize() {
        INSTANCE = this;
        this.dataStore = DataStore.create(this.getServer());
        BlockEvent.BREAK.register((level, pos, state, player, xp) -> {
            if (level == null || level.m_7654_() == null || level.f_46443_ || this.dataStore == null) {
                return EventResult.pass();
            }
            if (state.m_60734_() != Blocks.f_50085_) {
                return EventResult.pass();
            }
            BlockEntity blockEntity = level.m_7702_(pos);
            if (!(blockEntity instanceof SpawnerBlockEntity)) {
                return EventResult.pass();
            }
            SpawnerBlockEntity spawnerBlockEntity = (SpawnerBlockEntity)blockEntity;
            CompoundTag compound = spawnerBlockEntity.m_187482_();
            DataStore dataStore = this.dataStore;
            dataStore.brokenSpawners.add(new MobSpawnerData(pos, compound, (ResourceKey<Level>)level.m_46472_()));
            dataStore.m_77762_();
            if (((Boolean)PCServerConfig.PUNISH_BREAKING_SPAWNER.get()).booleanValue()) {
                this.spawnPunishment(player, level, pos, compound);
            }
            return EventResult.pass();
        });
        TickEvent.ServerLevelTick.SERVER_LEVEL_POST.register(this::onServerTick);
    }

    private void spawnPunishment(ServerPlayer player, Level level, BlockPos spawnerPos, CompoundTag compound) {
        if (!compound.m_128441_("SpawnData")) {
            return;
        }
        SpawnData spawnData = SpawnData.f_186559_.parse((DynamicOps)NbtOps.f_128958_, (Object)compound.m_128469_("SpawnData")).resultOrPartial(string -> LOGGER.warn("Invalid SpawnData: {}", string)).orElseGet(SpawnData::new);
        CompoundTag entityCompound = spawnData.m_186567_();
        BoundingBox box = new BoundingBox(spawnerPos).m_191961_(3);
        box = box.m_71045_(0, spawnerPos.m_123342_() - box.m_162396_(), 0);
        ArrayList<BlockPos> airBlocks = new ArrayList<BlockPos>();
        ArrayList<BlockPos> toCheck = new ArrayList<BlockPos>();
        toCheck.add(spawnerPos);
        while (!toCheck.isEmpty()) {
            BlockPos currentPos = (BlockPos)toCheck.remove(0);
            BlockState currentState = level.m_8055_(currentPos);
            if (!currentState.m_60795_() && !currentState.m_60767_().m_76336_() && currentState.m_60734_() != Blocks.f_50085_) continue;
            airBlocks.add(currentPos);
            List<BlockPos> nextLocations = List.of(currentPos.m_122012_(), currentPos.m_122019_(), currentPos.m_122029_(), currentPos.m_122024_(), currentPos.m_7495_(), currentPos.m_7494_());
            for (BlockPos nextLocation : nextLocations) {
                if (toCheck.contains(nextLocation) || airBlocks.contains(nextLocation) || !box.m_71051_((Vec3i)nextLocation)) continue;
                toCheck.add(nextLocation);
            }
        }
        List<BlockPos> validBlocks = airBlocks.stream().filter(e -> e.m_123342_() < spawnerPos.m_123342_() + 2).toList();
        if (validBlocks.isEmpty()) {
            return;
        }
        ArrayList<BlockPos> alreadyTaken = new ArrayList<BlockPos>();
        int mobsToSpawn = level.f_46441_.m_216339_(2, 8);
        int tries = 0;
        while (++tries < 15 && alreadyTaken.size() < mobsToSpawn) {
            BlockPos randomPos = validBlocks.get(level.f_46441_.m_188503_(validBlocks.size()));
            if (alreadyTaken.contains(randomPos)) continue;
            alreadyTaken.add(randomPos);
            Entity entity = EntityType.m_20645_((CompoundTag)entityCompound, (Level)level, Function.identity());
            if (entity == null) continue;
            entity.m_6034_((double)randomPos.m_123341_() + 0.5, (double)randomPos.m_123342_(), (double)randomPos.m_123343_() + 0.5);
            level.m_7967_(entity);
            player.f_8906_.m_9829_((Packet)new ClientboundCustomSoundPacket(SoundEvents.f_12599_.m_11660_(), SoundSource.AMBIENT, new Vec3((double)randomPos.m_123341_(), (double)randomPos.m_123342_(), (double)randomPos.m_123343_()), 0.3f, 0.4f, (long)level.f_46441_.m_188502_()));
        }
    }

    @Override
    public boolean isDisabled() {
        return (Boolean)PCServerConfig.SPAWNERS_ALLOW_RESPAWN.get() == false;
    }

    private void onServerTick(ServerLevel serverLevel) {
        if (serverLevel.m_46467_() % 200L != 0L) {
            return;
        }
        DataStore dataStore = this.getDataStore();
        if (dataStore == null || dataStore.brokenSpawners.isEmpty()) {
            return;
        }
        List<MobSpawnerData> dimensionSpawners = dataStore.brokenSpawners.stream().filter(e -> e.dimension().equals((Object)serverLevel.m_46472_())).toList();
        if (dimensionSpawners.isEmpty()) {
            return;
        }
        Instant currentTime = Instant.now();
        int respawnInterval = (Integer)PCServerConfig.SPAWNERS_RESPAWN_INTERVAL.get();
        for (MobSpawnerData spawnerData : dimensionSpawners) {
            if (currentTime.isBefore(spawnerData.breakTime.plus((long)respawnInterval, ChronoUnit.MINUTES))) continue;
            BlockState state = serverLevel.m_8055_(spawnerData.pos);
            if (!state.m_60795_() || !state.m_60767_().m_76336_()) {
                dataStore.brokenSpawners.remove(spawnerData);
                dataStore.m_77762_();
                continue;
            }
            serverLevel.m_7731_(spawnerData.pos, Blocks.f_50085_.m_49966_(), 3);
            BlockEntity blockEntity = serverLevel.m_7702_(spawnerData.pos);
            if (!(blockEntity instanceof SpawnerBlockEntity)) continue;
            SpawnerBlockEntity spawnerBlockEntity = (SpawnerBlockEntity)blockEntity;
            CompoundTag compound = spawnerData.spawnerData;
            List<EntityType<?>> randomEntities = this.randomEntities.get();
            if (!randomEntities.isEmpty()) {
                EntityType<?> foundEntity = randomEntities.size() == 1 ? randomEntities.get(0) : randomEntities.get(serverLevel.f_46441_.m_188503_(randomEntities.size()));
                CompoundTag entityCompound = (CompoundTag)Util.m_137469_((Object)new CompoundTag(), tag -> tag.m_128365_("entity", (Tag)Util.m_137469_((Object)new CompoundTag(), entityTag -> entityTag.m_128359_("id", Objects.requireNonNull(foundEntity.arch$registryName()).toString()))));
                compound.m_128365_("SpawnData", (Tag)entityCompound);
            }
            spawnerBlockEntity.m_142466_(compound);
            spawnerBlockEntity.m_6596_();
            dataStore.brokenSpawners.remove(spawnerData);
            dataStore.m_77762_();
        }
    }

    public static SpawnerManager get() {
        return INSTANCE;
    }

    @Nullable
    public DataStore getDataStore() {
        return this.dataStore;
    }

    public static class DataStore
    extends SavedData {
        private final List<MobSpawnerData> brokenSpawners = new ArrayList<MobSpawnerData>();

        private DataStore() {
        }

        private DataStore(CompoundTag tag) {
            if (!tag.m_128441_("broken_spawners")) {
                return;
            }
            this.brokenSpawners.addAll(MobSpawnerData.CODEC.listOf().parse(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128469_("broken_spawners"))).result().orElse(new ArrayList()));
        }

        public static DataStore create(MinecraftServer server) {
            return (DataStore)server.m_129880_(Level.f_46428_).m_8895_().m_164861_(DataStore::new, DataStore::new, "ftbpc-spawner-manager");
        }

        @NotNull
        public CompoundTag m_7176_(CompoundTag compoundTag) {
            compoundTag.m_128365_("broken_spawners", (Tag)MobSpawnerData.CODEC.listOf().encodeStart((DynamicOps)NbtOps.f_128958_, this.brokenSpawners).result().orElse(new CompoundTag()));
            return compoundTag;
        }

        public List<MobSpawnerData> getBrokenSpawners() {
            return this.brokenSpawners;
        }
    }

    public record MobSpawnerData(BlockPos pos, CompoundTag spawnerData, Instant breakTime, ResourceKey<Level> dimension) {
        private static final Codec<ResourceKey<Level>> DIMENSION_CODEC = ResourceKey.m_195966_((ResourceKey)Registry.f_122819_);
        private static final Codec<Instant> INSTANT_CODEC = Codec.LONG.xmap(Instant::ofEpochMilli, Instant::toEpochMilli);
        public static final Codec<MobSpawnerData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockPos.f_121852_.fieldOf("pos").forGetter(MobSpawnerData::pos), (App)CompoundTag.f_128325_.fieldOf("spawner_data").forGetter(MobSpawnerData::spawnerData), (App)INSTANT_CODEC.fieldOf("break_time").forGetter(MobSpawnerData::breakTime), (App)DIMENSION_CODEC.fieldOf("dimension").forGetter(MobSpawnerData::dimension)).apply((Applicative)instance, MobSpawnerData::new));

        public MobSpawnerData(BlockPos pos, CompoundTag spawnerData, ResourceKey<Level> dimension) {
            this(pos, spawnerData, Instant.now(), dimension);
        }
    }
}

